<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ page import="java.util.Calendar" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.cabo.ui.data.DataObject" %>
<%@ page import="oracle.cabo.ui.data.DataObjectList" %>
<%@ page import="oracle.sysman.emSDK.chart.ChartColorTable" %>
<%@ page import="oracle.sysman.emSDK.chart.EmChartConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.ctlr.BaselineConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.model.BSLNConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.view.MetricAnalysisPage" %>

<%-- JavaBean references --%>

<jsp:useBean id="pageBean"
             scope="request"
             type="oracle.sysman.dbTarget.db.bsln.view.MetricAnalysisPage"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
function initializeSelection(selectedValue)
{
  if ("<%= BaselineConstants.ANALYSISMODE_ADVANCED %>" ==
      "<%= pageBean.getAnalysisMode() %>")
  {
    if (document.metricDisplayForm.<%= BaselineConstants.PARAM_TRENDSTYLE %>[1].value == "<%= pageBean.getTrendStyle() %>")
    {
      selectNormalizedData();
    }
    else
    {
      selectRawData();
    }
  }
}

function selectRawData()
{
  document.metricDisplayForm.<%= BaselineConstants.PARAM_MAXIMUM %>.disabled = false;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_9999PCTILE %>.disabled = false;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_999PCTILE %>.disabled = false;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_99PCTILE %>.disabled = false;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_MEDIAN %>.disabled = false;

  document.metricDisplayForm.<%= BaselineConstants.PARAM_NORMALIZATIONTYPE %>[0].disabled = true;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_NORMALIZATIONTYPE %>[1].disabled = true;
}

function selectNormalizedData()
{
  document.metricDisplayForm.<%= BaselineConstants.PARAM_MAXIMUM %>.disabled = true;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_9999PCTILE %>.disabled = true;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_999PCTILE %>.disabled = true;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_99PCTILE %>.disabled = true;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_MEDIAN %>.disabled = true;

  document.metricDisplayForm.<%= BaselineConstants.PARAM_NORMALIZATIONTYPE %>[0].disabled = false;
  document.metricDisplayForm.<%= BaselineConstants.PARAM_NORMALIZATIONTYPE %>[1].disabled = false;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="msgs" class="oracle.sysman.db.bsln.BaselineMsg"/>
  <uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineConstants.ATTRNAME_PAGEBEAN+"@servletRequest" %>'>

    <uix:body onLoad="initializeSelection()">
      <uix:pageLayout titleBinding="TITLE_PAGE_BASELINEMETRICTHRESHOLDS@msgs">

        <%@ include file="/database/global.jspf" %>

        <uix:tableLayout width="100%">
          <%--
            == Warning message that statistics are required for this
            == page.
            --%>
          <uix:rowLayout renderedBinding="noStatisticsAvailable">
            <uix:messageStyledText textBinding="statisticsRequiredMessage"
                                   styleClass="OraTipText"
                                   messageType="<%= UIConstants.MESSAGE_TYPE_WARNING %>"/>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="1">
             <uix:contents>
              <uix:link textBinding="TITLE_TAB_ALERTCONFIGURATION@msgs"
                        destinationBinding="alertConfigurationURL"/>
              <uix:link textBinding="metricAnalysisTabTitle"/>
             </uix:contents>
            </uix:subTabBar>
          </uix:subTabs>

         <uix:contents>

<%
final int _COL_1_WIDTH=600;
final int _COL_2_WIDTH=300;
final int _COL_HGAP=10;
%>

          <uix:switcher childNameBinding="analysisMode">
            <uix:default>
              <%@ include file="metricAnalysisDirected.jspf" %>
            </uix:default>

            <uix:case name="<%= BaselineConstants.ANALYSISMODE_ADVANCED %>">
              <%@ include file="metricAnalysisAdvanced.jspf" %>
            </uix:case>
          </uix:switcher>
         </uix:contents>

        </uix:subTabLayout>

        <oem:relatedLinks/>

      </uix:pageLayout>

    </uix:body>

    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
