<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.ctlr.BaselineConstants" %>

<%-- JavaScript functions --%>

<script language="JavaScript">
function confirm()
{
  document.quickConfigForm.<%= BaselineConstants.PARAM_CONFIRMED %>.value =
   '<%= BaselineConstants.YES %>';
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="msgs" class="oracle.sysman.db.bsln.BaselineMsg"/>
  <uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding="pageBean@servletRequest">
      <uix:body>
        <uix:pageLayout titleBinding="title">

          <%@ include file="/database/global.jspf" %>

          <uix:form name="quickConfigForm"
                    destinationBinding="eventURL">
           <uix:contents>

            <uix:formValue name="<%= BaselineConstants.PARAM_SYSTEMPROFILE %>"
                           valueBinding="systemProfile"/>
            <uix:formValue name="<%= BaselineConstants.PARAM_CONFIRMED %>"
                           value="<%= BaselineConstants.NO %>"/>

            <uix:stackLayout>
             <uix:contents>

              <uix:header textBinding="summary">

              <uix:spacer width="1" height="10"/>

              <uix:table summaryBinding="summary"
                         tableDataBinding="applied"
                         width="90%">
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_METRICNAME@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="29%"/>
                 <uix:contents>
                  <uix:styledText textBinding="metricLabel"
                                  styleClass="OraPromptText"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_AWRBASELINE@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="20%"/>
                 <uix:contents>
                  <uix:styledText textBinding="baselineLabel"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_THRESHOLDTYPE@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="20%"/>
                 <uix:contents>
                  <uix:styledText textBinding="thresholdingMethodLabel"
                                  shortDescBinding="thresholdingMethodDesc"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_WARNINGLEVEL@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="13%"/>
                 <uix:contents>
                  <uix:styledText textBinding="warningLabel"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_CRITICALLEVEL@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="13%"/>
                 <uix:contents>
                  <uix:styledText textBinding="criticalLabel"/>
                 </uix:contents>
                </uix:column>
              </uix:table>

              </uix:header>

              <uix:header renderedBinding="anyToClear"
                          textBinding="TITLE_TABLE_QUICKCONFIGCLEARED@msgs">
              <uix:spacer width="1" height="10"/>

              <uix:messageStyledText textBinding="clearWarningText"
                                     styleClass="OraTipText"
                                     messageType="warning"/>

              <uix:spacer width="1" height="10"/>

              <uix:table tableDataBinding="cleared"
                         summaryBinding="TITLE_TABLE_QUICKCONFIGCLEARED@msgs"
                         width="90%">
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_METRICNAME@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="29%"/>
                 <uix:contents>
                  <uix:styledText textBinding="metricLabel"
                                  styleClass="OraPromptText"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_AWRBASELINE@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="20%"/>
                 <uix:contents>
                  <uix:styledText textBinding="baselineLabel"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_THRESHOLDTYPE@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="20%"/>
                 <uix:contents>
                  <uix:styledText textBinding="thresholdingMethodLabel"
                                  shortDescBinding="thresholdingMethodDesc"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_WARNINGLEVEL@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="13%"/>
                 <uix:contents>
                  <uix:styledText textBinding="warningLabel"/>
                 </uix:contents>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRNAME_CRITICALLEVEL@msgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="13%"/>
                 <uix:contents>
                  <uix:styledText textBinding="criticalLabel"/>
                 </uix:contents>
                </uix:column>
              </uix:table>

              </uix:header>

              <uix:spacer width="1" height="10"/>

             </uix:contents>
            </uix:stackLayout>

           </uix:contents>
          </uix:form>

          <%-- Confirmation buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton formName="quickConfigForm"
                                textBinding="CANCEL@sdkMsgs"
                                event="<%= BaselineConstants.EVENT_QUICKCONFIG %>"/>
              <uix:button textBinding="BACK@sdkMsgs"
                          destinationBinding="quickConfigURL"/>
              <uix:submitButton formName="quickConfigForm"
                                textBinding="FINISH@sdkMsgs"
                                event="<%= BaselineConstants.EVENT_QUICKCONFIG %>"
                                onClick="confirm()"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
