<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.ctlr.BaselineConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.view.QuickConfigPopupPage" %>

<%-- JavaScript functions --%>

<script language="JavaScript">
function deny()
{
  document.quickConfigForm.<%= BaselineConstants.PARAM_CONFIRMED %>.value =
   '<%= BaselineConstants.NO %>';
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="msgs" class="oracle.sysman.db.bsln.BaselineMsg"/>
  <uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding="pageBean@servletRequest">

      <uix:body>
        <uix:pageLayout titleBinding="TITLE_PAGE_QUICKCONFIG@msgs">

          <%@ include file="/database/global.jspf" %>

        <uix:form name="quickConfigForm"
                  method="POST"
                  destinationBinding="eventURL">
          <uix:formValue name="<%= BaselineConstants.PARAM_CONFIRMED %>"/>

<uix:tableLayout width="100%">
  <uix:rowLayout><uix:cellFormat columnSpan="6"><uix:spacer width="1" height="12"/></uix:cellFormat></uix:rowLayout>
  <uix:rowLayout>
    <uix:cellFormat wrappingDisabled="true">
      <uix:styledText styleClass="OraPromptText"
                      textBinding="ATTRNAME_SYSTEMPROFILE@msgs"/>
    </uix:cellFormat>
    <uix:cellFormat rowSpan="3"><uix:spacer width="10" height="1"/></uix:cellFormat>
    <uix:cellFormat columnSpan="4" width="100%">
      <uix:radioButton name="<%= BaselineConstants.PARAM_SYSTEMPROFILE %>"
                       textBinding="CHOICE_OLTP@msgs"
                       value="<%= BaselineConstants.SYSTEMPROFILE_OLTP %>"
                       selectedValueBinding="systemProfile"/>
    </uix:cellFormat>
  </uix:rowLayout>
  <uix:rowLayout>
    <uix:cellFormat rowSpan="2"><uix:spacer width="10" height="1"/></uix:cellFormat>
    <uix:cellFormat columnSpan="4">
      <uix:radioButton name="<%= BaselineConstants.PARAM_SYSTEMPROFILE %>"
                       textBinding="CHOICE_DSS@msgs"
                       value="<%= BaselineConstants.SYSTEMPROFILE_DSS %>"
                       selectedValueBinding="systemProfile"/>
    </uix:cellFormat>
  </uix:rowLayout>
  <uix:rowLayout>
    <uix:cellFormat columnSpan="4">
      <uix:radioButton name="<%= BaselineConstants.PARAM_SYSTEMPROFILE %>"
                       textBinding="CHOICE_BACKOFFICE@msgs"
                       value="<%= BaselineConstants.SYSTEMPROFILE_BACKOFFICE %>"
                       selectedValueBinding="systemProfile"/>
    </uix:cellFormat>
  </uix:rowLayout>
  <uix:rowLayout><uix:cellFormat columnSpan="6"><uix:spacer width="1" height="12"/></uix:cellFormat></uix:rowLayout>
  <uix:rowLayout>
    <uix:cellFormat vAlign="top" columnSpan="6">
      <uix:messageStyledText styleClass="OraTipText"
                             messageType="warning"
                             textBinding="TIP_QUICKCONFIG_EFFECT@msgs"/>
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

         </uix:form>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs"
                                formName="quickConfigForm"
                                event="<%= BaselineConstants.EVENT_QUICKCONFIG %>"
                                onClick="deny()"/>
              <uix:submitButton textBinding="CONTINUE@sdkMsgs"
                                formName="quickConfigForm"
                                event="<%= BaselineConstants.EVENT_QUICKCONFIG %>"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:pageStatus>
            <uix:styledText textBinding="INSTR_SELECT_QUICKCONFIG_PROFILE@msgs"
                            styleClass="OraPromptText"/>
          </uix:pageStatus>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
