<%--
  -- Name:        em/database/baselines/registerDataSources.jsp
  -- Description: This is the JSP for the Register Metrics page.
  --
  -- Controller:  oracle.sysman.dbTarget.metrics.bsln.ctlr.DbBaselineController
  --
  -- Notes:       
  --
  -- MODIFIED     (MM/DD/YY)
  --   jsoule      07/13/05 - add noscript import 
  --   jsoule      06/27/05 - jsoule_baselines_0620
  --   jsoule      06/06/05 - overrode from core
  --   jsoule      03/09/05 - use target, type in renderForm 
  --   jsoule      01/26/05 - add systemStatus page
  --   jsoule      10/15/04 - jsoule_grid_baseline_support
  --   jsoule      10/12/04 - Created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>
<%@ page import="oracle.sysman.emSDK.eml.SDKUIMsgID" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineConstants" %>
<%@ page import="oracle.sysman.emSDK.page.mtrx.bsln.BaselineUIConstants" %>
<%@ page import="oracle.sysman.db.bsln.BaselineMsgID" %>

<%-- JavaBean references --%>

<jsp:useBean id="baselinePageView"
             scope="request"
             type="oracle.sysman.dbTarget.metrics.bsln.ctlr.RegisterDataSourcesPageView"/>

<%-- JavaScript functions --%>

<script language="JavaScript">
<%--
  Function:    getSelectedMetrics

  Arguments:   formName - the name of the form

  Description: This JavaScript encodes the selected hGrid tree items
               into a single form input.
  --%>
function getSelectedMetrics(formName)
{
  var selected = new Array();

  var metricC =
   document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.elements["<%= BaselineUIConstants.NAME_TABLE_REGISTERDATASOURCES %>:length"].value;
  var metricI;

  for (metricI = 0; metricI < metricC; metricI++)
  {
    if (document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.elements["<%= BaselineUIConstants.NAME_TABLE_REGISTERDATASOURCES %>:selected:"+metricI].checked)
    {
      var metric =
       document.<%= BaselineUIConstants.NAME_FORM_RENDER %>.elements["<%= BaselineUIConstants.NAME_TABLE_REGISTERDATASOURCES %>:<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>:"+metricI].value;
      selected.push(metric);
    }
  }

  document.forms[formName].<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>.value = selected.join("<%= BaselineUIConstants.PARAM_SEPARATOR %>");
  return false;
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="<%= BaselineUIConstants.ATTR_BASELINEBUNDLE %>"
              class="oracle.sysman.db.bsln.BaselineMsg"/>
  <uix:bundle name="<%= BaselineUIConstants.ATTR_SDKBUNDLE %>"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'>
      <uix:body>
        <uix:pageLayout titleBinding='<%= BaselineMsgID.TITLE_REGISTERDATASOURCES+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>

          <%@ include file="/oemGlobal.jspf" %>

          <%-- Message area --%>

          <%@ include file="/database/baselines/baselineMessage.jspf" %>

          <%-- Categorized Eligible Metrics --%>

          <%-- This form accommodates table navigation. --%>
          <uix:form name="<%= BaselineUIConstants.NAME_FORM_RENDER %>"
                    destination='<%= baselinePageView.getContextPath() + "/console/database/" + BaselineUIConstants.REGISTER_DATASOURCES_PAGE %>'
                    onSubmit="getSelectedMetrics('renderForm')">

            <uix:spacer height="20"/>

            <%-- The metric tree --%>
            <uix:hGrid id="registerDataSourcesTable"
                       summaryBinding='<%= BaselineMsgID.CATEGORY_ALL+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                       treeDataBinding="<%= BaselineUIConstants.ATTR_DATAOBJECT %>"
                       proxyBinding='<%= BaselineUIConstants.NAME_TABLE_REGISTERDATASOURCES+":proxy@"+BaselineUIConstants.ATTR_STATE+"@"+BaselineUIConstants.ATTR_PAGEVIEW+"@servletRequest" %>'
                       width="600"
                       formSubmitted="true">

              <uix:tableSelection>
                <uix:multipleSelection selectedBinding="<%= UIConstants.SELECTED_KEY %>"
                                       disabledBinding="<%= UIConstants.DISABLED_ATTR.getAttributeName() %>"
                                       shortDescBinding='<%= BaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'>
                 <uix:contents>
                  <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_REGISTERDATASOURCES %>"
                                    textBinding='<%= BaselineMsgID.ACTION_REGISTER+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                    name="<%= UIConstants.EVENT_PARAM %>"
                                    value="<%= BaselineUIConstants.EVENT_REGISTER %>"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton formName="<%= BaselineUIConstants.NAME_FORM_REGISTERDATASOURCES %>"
                                    textBinding='<%= BaselineMsgID.ACTION_DEREGISTER+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'
                                    name="<%= UIConstants.EVENT_PARAM %>"
                                    value="<%= BaselineUIConstants.EVENT_DEREGISTER %>"/>
                 </uix:contents>
                </uix:multipleSelection>
              </uix:tableSelection>

              <%-- Hierarchy column --%>
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding='<%= BaselineMsgID.ATTRNAME_METRICNAME+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                    width="75%"/>
                 <uix:contents>
                  <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_METRICLABEL %>" />
                  <%-- (this hidden form value identifies the metric) --%>
                  <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRIC %>"
                                 valueBinding="<%= BaselineUIConstants.VIEW_ATTR_GUID %>" />
                 </uix:contents>
                </uix:column>    
              </uix:nodeStamp>

             <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding='<%= BaselineMsgID.ATTRNAME_REGISTRATIONSTATUS+"@"+BaselineUIConstants.ATTR_BASELINEBUNDLE %>'/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="<%= UIConstants.TEXT_FORMAT %>"
                                  width="20%"/>
               <uix:contents>
                <uix:styledText textBinding="<%= BaselineUIConstants.VIEW_ATTR_REGISTRATIONSTATUS %>" />
               </uix:contents>
              </uix:column>
             </uix:contents>
            </uix:hGrid>

            <%-- Hidden form values --%>
            <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
              <uix:formValue name="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
              <uix:formValue name="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"
                             valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
            </uix:dataScope>

            <%-- (this is the list of selected metrics) --%>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
          </uix:form>

          <%-- (this form submits the register/deregister event) --%>
          <uix:form name="<%= BaselineUIConstants.NAME_FORM_REGISTERDATASOURCES %>"
                    destination='<%= request.getContextPath() + BaselineUIConstants.URI_BASELINE_EVENT %>'
                    onSubmit="getSelectedMetrics('registerDataSourcesForm')">
           <%-- Hidden form values --%>
           <uix:dataScope currentDataBinding="<%= BaselineUIConstants.VIEW_ATTR_RESULTS %>">
            <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_NAME %>"
                           valueBinding="<%= EmlConstants.TARGET_PAGE_PROPERTY %>"/>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_TARGET_TYPE %>"
                           valueBinding="<%= EmlConstants.TARGET_TYPE_PAGE_PROPERTY %>"/>
           </uix:dataScope>
            <%-- (this is the list of selected metrics) --%>
            <uix:formValue name="<%= BaselineUIConstants.PARAM_BASELINE_METRICS %>"/>
          </uix:form>

          <%-- Related Links area --%>

          <%@ include file="/database/baselines/baselineRelatedLinks.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>

              <%-- Return button --%>
              <uix:button textBinding='<%= SDKUIMsgID.OK+"@"+BaselineUIConstants.ATTR_SDKBUNDLE %>'
                          destinationBinding="<%= BaselineUIConstants.VIEW_ATTR_MANAGEURI %>"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>

      </uix:body>
    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
