<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ page import="java.util.Calendar" %>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.dbTarget.db.bsln.ctlr.BaselineConstants" %>

<%-- JavaScript functions --%>

<script language="JavaScript">
function confirm()
{
  document.scheduleComputeForm.<%= BaselineConstants.PARAM_CONFIRMED %>.value =
   '<%= BaselineConstants.YES %>';
}
</script>

<%-- JSP Rendering Tags --%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="msgs" class="oracle.sysman.db.bsln.BaselineMsg"/>
  <uix:bundle name="jobsMsgs" class="oracle.sysman.db.rsc.inst.JobsMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="dbObjMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:dataScope currentDataBinding='<%= BaselineConstants.ATTRNAME_PAGEBEAN+"@servletRequest" %>'>

    <uix:body>

      <uix:pageLayout titleBinding="title">

        <%@ include file="/database/global.jspf" %>

        <uix:stackLayout>
         <uix:form name="scheduleComputeForm"
                   method="POST"
                   destinationBinding="eventURL">

          <uix:formValue name="<%= BaselineConstants.PARAM_CONFIRMED %>"
                         value="<%= BaselineConstants.NO %>"/>

          <uix:header textBinding="HEADER_TASKINFO@msgs">
            <uix:labeledFieldLayout labelWidth="15%">
             <uix:contents>
              <uix:messageTextInput promptBinding="ATTRNAME_TASKNAME@msgs"
                                    required="yes"
                                    id="<%= BaselineConstants.PARAM_JOBNAME %>"
                                    name="<%= BaselineConstants.PARAM_JOBNAME %>"
                                    textBinding="defaultTaskName"
                                    columns="60"/>
              <uix:messageTextInput promptBinding="ATTRNAME_TASKDESC@msgs"
                                    id="<%= BaselineConstants.PARAM_JOBDESC %>"
                                    name="<%= BaselineConstants.PARAM_JOBDESC %>"
                                    textBinding="defaultTaskDescription"
                                    columns="60"/>
             </uix:contents>
            </uix:labeledFieldLayout>
          </uix:header>

          <uix:header textBinding="SCHEDULE@jobsMsgs">
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="SCHE_TYPE@jobsMsgs"/>
                </uix:cellFormat>
                <uix:spacer width="10"/>
                <uix:styledText textBinding="SCHE_CAL@jobsMsgs"
                                styleClass="OraDataText"/>
              </uix:rowLayout>
              <uix:spacer height="5"/> 

              <uix:header text="">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="TIME_ZONE@sdkMsgs"/>
                  </uix:cellFormat>
                  <uix:spacer width="3"/>
                  <uix:cellFormat>
                    <uix:styledText textBinding="timeZone"
                                    styleClass="OraDataText"/>
                  </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>           

                <uix:header textBinding="REPEATING_HEADER@sdkMsgs">

                  <uix:spacer height="4"/>

                  <uix:tableLayout cellSpacing="10">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText textBinding="REPEAT_HEADER@sdkMsgs"
                                        styleClass="OraPromptText"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText textBinding="DO_NOT_REPEAT@sdkMsgs"
                                        styleClass="OraDataText"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                </uix:header>

                <uix:header textBinding="START@sdkMsgs">

                  <uix:tip>
                    <uix:styledText textBinding="TIP_TASKCOMPUTE_COSTLY@msgs"/>
                  </uix:tip>

                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <%-- IMMEDIATELY RADIO BUTTON --%>
                      <uix:radioButton name="<%= BaselineConstants.PARAM_SCHEDULESTART %>"
                                       value="<%= BaselineConstants.SCHEDULESTART_NOW %>"
                                       selectedValue="<%= BaselineConstants.SCHEDULESTART_NOW %>"
                                       textBinding="IMMEDIATELY@sdkMsgs"
                                       styleClass="OraInstructionText"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <%-- LATER RADIO BUTTON --%>
                      <uix:radioButton name="<%= BaselineConstants.PARAM_SCHEDULESTART %>"
                                       value="<%= BaselineConstants.SCHEDULESTART_LATER %>"
                                       selectedValue="<%= BaselineConstants.SCHEDULESTART_NOW %>"
                                       textBinding="LATER@sdkMsgs"
                                       styleClass="OraInstructionText"/>	
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <%-- START DATE --%>
                      <uix:cellFormat hAlign="right">
                      </uix:cellFormat>
                      <uix:messageDateField id="DATE"
                                            shortDescBinding="DATE@sdkMsgs"
                                            name="<%= BaselineConstants.PARAM_DATE %>"
                                            promptBinding="DATE@sdkMsgs"
                                            tipBinding="exampleDate"
                                            valueBinding="currentDate"
                                            columns="24">
                        <uix:onSubmitValidater>
                          <uix:date dateStyle="short"/>
                        </uix:onSubmitValidater>
                      </uix:messageDateField>
                    </uix:rowLayout>

                    <uix:rowLayout hAlign="right">
                      <%-- START HOUR --%>
                      <uix:cellFormat  hAlign="right">
                      </uix:cellFormat>
                      <uix:cellFormat  hAlign="left">
                        <uix:messagePrompt promptBinding="TIME@sdkMsgs"/>
                        <uix:spacer width="5" height="10"/>
                        <uix:flowLayout>
                          <uix:choice name="<%= BaselineConstants.PARAM_HOUR %>"
                                      shortDescBinding="HOURS@sdkMsgs"
                                      selectedValueBinding="currentHour">
                           <uix:contents>
                            <uix:option text="12"/>
                            <uix:option text="1"/>
                            <uix:option text="2"/>
                            <uix:option text="3"/>
                            <uix:option text="4"/>
                            <uix:option text="5"/>
                            <uix:option text="6"/>
                            <uix:option text="7"/>
                            <uix:option text="8"/>
                            <uix:option text="9"/>
                            <uix:option text="10"/>
                            <uix:option text="11"/>
                           </uix:contents>
                          </uix:choice>

                          <%-- START MINUTE --%>
                          <uix:choice name="<%= BaselineConstants.PARAM_MINUTE %>"
                                      shortDescBinding="MINUTES@sdkMsgs"
                                      selectedValueBinding="currentMinute">
                           <uix:contents>
                            <uix:option text="00" value="0"/>
                            <uix:option text="10"/>
                            <uix:option text="20"/>
                            <uix:option text="30"/>
                            <uix:option text="40"/>
                            <uix:option text="50"/>
                           </uix:contents>
                          </uix:choice>

                          <%-- START AM/PM --%>
                          <uix:radioButton name="<%= BaselineConstants.PARAM_AMPM %>" 
                                           value="<%= Calendar.AM %>"
                                           selectedValueBinding="currentAmPm"
                                           textBinding="AM_LABEL@sdkMsgs"
                                           styleClass="OraInstructionText"/>
                          <uix:radioButton name="<%= BaselineConstants.PARAM_AMPM %>" 
                                           value="<%= Calendar.PM %>"
                                           selectedValueBinding="currentAmPm"
                                           textBinding="PM_LABEL@sdkMsgs"
                                           styleClass="OraInstructionText"/>
                        </uix:flowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>

                  </uix:tableLayout>
                </uix:header>

              </uix:header>
            </uix:stackLayout>
          </uix:header>
         </uix:form>
        </uix:stackLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton formName="scheduleComputeForm"
                              textBinding="CANCEL@sdkMsgs"/>
            <uix:submitButton formName="scheduleComputeForm"
                              textBinding="SUBMIT@dbObjMsgs"
                              onClick="confirm()"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>

    </uix:body>

    </uix:dataScope>

  </uix:document>

</uix:renderingContext>
