<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">  
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:switcher childNameBinding="autoRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText>
        <meta http-equiv="Refresh"
              content="<%=request.getAttribute("refreshRate")%>; URL=<%=request.getAttribute("refreshUrl") %>" >
        </uix:rawText> 
      </uix:case>  
    </uix:switcher>
    
    <uix:document> 

      <%@ include file="/enablePPR.jspf" %>
      <%@ include file="/oemTitle.jspf" %>
      <uix:body>

        <db:form name="cells" method="post" destination="/console/database/cell/cellList" >
          <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:header textBinding="header@cellsBean@servletRequest" >

              <uix:stackLayout>
                <!-- ============== show update time =========== -->
                <uix:tableLayout width="100%" > 
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat>
                      <uix:rowLayout> 
                        <uix:styledText styleClass="OraTipText" 
                                        textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                        <uix:spacer width="5" />  
                        <uix:styledText styleClass="OraTipLabel" 
                                        textBinding="refreshTime@servletRequest"/>
                        <uix:spacer width="10" />
                        <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                                    destinationBinding="refreshDest@servletRequest"
                                    shortDescBinding="REFRESH@SDKBundle@servletRequest" />

                        <uix:spacer width="10" />
                        <uix:styledText styleClass="OraFieldText" 
                                        textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                                        labeledNodeId="ViewLabel" />
                        
                        <uix:spacer width="10" />
                        <uix:choice name="autoRefresh" id="ViewLabel"
                                    onChange="submitForm('cells', true, {'event':'doLoad'})"
                                    selectedValueBinding="autoRefreshSelected@servletRequest">
                          <uix:option textBinding="MANUALLY_REFRESH@DBMsgBundle@servletRequest"
                                      value="RT_MAN"/>
                          <uix:option textBinding="AUTOMATICALLY_REFRESH_1MIN@DBMsgBundle@servletRequest"
                                      value="RT_60"/> 
                        </uix:choice>          
                      </uix:rowLayout>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                </uix:tableLayout> 

                <uix:spacer height="5" />


                <uix:rowLayout>
                <uix:cellFormat wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText" 
                        textBinding="VIEW_REPORTS@cellMsgBundle@servletRequest"/>  
                 </uix:cellFormat>
                 <uix:cellFormat wrappingDisabled="true">
                  <uix:spacer width="1"/>
                  <oem:choice name="reports"
                      onChange="submitForm('cells', true, {'event':'switchToReport'})" 
                      optionsBinding="realmReportList@servletRequest" 
                      selectedValueBinding="selectedReport@cellsBean@servletRequest"/>  
                 </uix:cellFormat>     
                  <uix:cellFormat>
                  <uix:spacer width="2"/>
                    <uix:button textBinding="GO@cellMsgBundle@servletRequest" 
                                destinationBinding="selectedReportUrl@servletRequest"/>
                  </uix:cellFormat>
              </uix:rowLayout>

                <uix:spacer height="5" />

                <uix:styledText styleClass="OraPromptText"
                                textBinding="EXADATA_TABLE_INTRO_TEXT@cellMsgBundle@servletRequest" /> 

                <uix:spacer height="5" />
                <oem:table name="cellListDataSource" width="95%"  
                           summaryBinding="EXADATA_LIST@cellMsgBundle@servletRequest"
                           partialRenderMode="self"
                           formSubmitted="true"                           
                           beanKey="cellsBean"                           
                           dataSourceProp="cellListDataSource"
                           blockSize="25"                           
                           alternateText="No cells found.">
                </oem:table>            
                <uix:spacer height="5"/>

              </uix:stackLayout>

            </uix:header> 

          </uix:pageLayout>
        </db:form>
      </uix:body>

    </uix:document> 
  </uix:renderingContext> 

