<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:document>   
  <%@ include file="/oemTitle.jspf" %> 
  <uix:styleSheet/>
  <uix:body>      

    <uix:pageLayout>
      <%@ include file="/oemGlobal.jspf" %>    

      <uix:spacer height="10"/>     
      <uix:stackLayout>
        <uix:contents>
          <uix:header textBinding="ADD_EXADATA@DBMsgBundle@servletRequest">
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:contentContainer
                   textBinding="OVERVIEW@cellMsgBundle@servletRequest"
                   width="100%">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                      textBinding="MANUAL_ADD_CELL_INSTR@cellMsgBundle@servletRequest"/>
                  <uix:styledList listStyle="decimal">
                    <uix:styledItem>
                      <uix:styledText styleClass="OraInstructionText"
                        textBinding="MANUAL_ADD_CELL_STEP1@cellMsgBundle@servletRequest"/>
                    </uix:styledItem>
                    <uix:styledItem>
                      <uix:styledText styleClass="OraInstructionText"
                        textBinding="MANUAL_ADD_CELL_STEP2@cellMsgBundle@servletRequest"/>
                    </uix:styledItem>
                    <uix:styledItem>
                      <uix:styledText styleClass="OraInstructionText"
                        textBinding="MANUAL_ADD_CELL_STEP3@cellMsgBundle@servletRequest"/>
                    </uix:styledItem>
                    <uix:styledItem>
                      <uix:styledText styleClass="OraInstructionText"
                        textBinding="MANUAL_ADD_CELL_STEP4@cellMsgBundle@servletRequest"/>
                    </uix:styledItem>
                    <uix:styledItem>
                      <uix:styledText styleClass="OraInstructionText"
                        textBinding="MANUAL_ADD_CELL_STEP5@cellMsgBundle@servletRequest"/>
                    </uix:styledItem>
                  </uix:styledList>
                </uix:stackLayout>
              </uix:contentContainer>
            </uix:stackLayout>

          </uix:header>
        </uix:contents>
      </uix:stackLayout>

      <uix:pageButtons> 
        <uix:pageButtonBar>
          <%-- CANCEL Button --%>
          <uix:button 
            textBinding="CANCEL@DBMsgBundle@servletRequest" 
            destinationBinding="returnUrl@servletRequest" />
          <%-- OK Button --%>
          <uix:button 
            textBinding="OK@DBMsgBundle@servletRequest" 
            destinationBinding="emdListUrl@servletRequest" />
        </uix:pageButtonBar>  
      </uix:pageButtons>

    </uix:pageLayout>       
  </uix:body> 
</uix:document> 
                     
</uix:renderingContext>
