<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       addComments.jsp
 *
 *      NOTES
 *       jsp for Bulk Add Comment Page.
 *       The bean key of the supporting model
 *       is 'addCommentsBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      05/17/05 - xshen_bug-4373232
 *    xshen      05/11/05 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@addCommentsBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="viewCommentForm" 
               method="POST"
               destinationBinding="addCommentsDest@addCommentsBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,guid,version,specGuid,specType,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/addComments"/>

        <uix:pageLayout 
             titleBinding="ADD_COMMENT@cmUIMsg">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

        <!-- Add Comments -->
          <uix:stackLayout>
            <uix:contents>
              <uix:rowLayout width="100%">
                <uix:messagePrompt 
                     promptBinding="ADD_COMMENT_INSTRUCTION@cmUIMsg"/>
              </uix:rowLayout>
              <uix:textInput name="comment" 
                   shortDescBinding="ADD_COMMENT_INSTRUCTION@cmUIMsg"
                   textBinding="comment@addCommentsBean@servletRequest"
                   maximumLength="4000"
                   columns="100"
                   rows="8"/>
            </uix:contents>
          </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@dbUIMsg"
                            shortDescBinding="CANCEL@dbUIMsg"
                            destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton textBinding="OK@dbUIMsg"
                                  shortDescBinding="OK@dbUIMsg"
                                  name="event"
                                  value="addCommentsOk"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
