<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       captureWizAddScopeItems.jsp
 *
 *      NOTES
 *       Launched from 'Add' on CM Capture wizard. 
 *
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   10/24/07 - 
 *    xshen      03/14/06 - bug 5090192 
 *    xshen      09/13/05 - bug 4606701 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/28/04 - adding instruction for exclude mode 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      08/20/04 - remove cancel URL 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      05/07/04 - ui changes
 *    xshen      04/29/04 - support object mode, add max row fetched msg
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/26/04 - Hook up with including page
 *    xshen      03/19/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@captureBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="captureForm" 
               method="POST"
               destinationBinding="captureDestination@captureBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/capture/captureWizAddScopeItems"/>
      <uix:formValue name="event" 
                     value="addItemsSearch"/>

        <uix:pageLayout 
             titleBinding="titleString@captureBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@captureBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="SOURCE@cmUIMsg" disabled="true"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg" disabled="true"/>
                  <uix:link textBinding="REVIEW@cmUIMsg" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout width="100%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="SOURCE_DATABASE@cmUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="target@captureBean@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="tgtUser@captureBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <uix:rowLayout width="100%" 
                           renderedBinding="excludeMode@captureBean@servletRequest">
              <uix:messagePrompt promptBinding="OBJECTS_ADD_EXCLUDE_SCHEMAS@cmUIMsg"/>
            </uix:rowLayout>

            <!-- Add Scope Items Included Page -->
            <%@ include file="/database/changemgr/addScopeItems.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


