<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       captureWizJobOpt.jsp
 *
 *      NOTES
 *       jsp for CM capture UI - Credential & Schedule page. 
 *       The key to the bean supporting the wizard
 *       is 'captureBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   10/24/07 - 
 *    xshen      02/14/05 - remove cancel url from form 
 *    xshen      02/11/05 - using page buttons include 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      06/28/04 - set unvalidate true (done in the backend)
 *    xshen      05/07/04 - ui changes
 *    xshen      04/16/04 - add header, repeating for schedule
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/31/04 - Add credential widget
 *    xshen      03/17/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@captureBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="captureForm" 
               method="POST"
               destinationBinding="captureDestination@captureBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/capture/captureWizJobOpt"/>

        <uix:pageLayout 
             titleBinding="titleString@captureBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@captureBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout  width="100%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="SOURCE_DATABASE@cmUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="target@captureBean@servletRequest"/>
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="tgtUser@captureBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <!-- Specify Credential: Use our own credential widget until 
              -- one available from sdk, both jspf and bean
              -->
            <%@ include file="/database/changemgr/cmCreds.jspf"%>

            <!-- Specify Schedule -->
            <uix:header textBinding="SCHEDULE@dbUIMsg">
              <%@ include file="/sdk/schedule/schedule.jspf"%>
            </uix:header>

            <%@ include file="/database/changemgr/capture/captureWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
