<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       captureWizardProcessing.jsp
 *
 *      NOTES
 *       jsp for CM capture UI - Processing page. 
 *       The key to the bean supporting the wizard
 *       is 'captureBean'
 *       This UI can be used if CM uses asynchronous 
 *       do capture (but without job system).  If 
 *       the job system model is used, there is no 
 *       need showing processing page.
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    kmckeen    09/01/04 - Remove percentComplete attr from uix:processing 
 *                          tag 
 *    xshen      04/22/04 - make comments
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/23/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:body>
      <uix:contents>

      <db:form name="captureForm" 
               method="POST"
               destinationBinding="captureDestination@captureBean@servletRequest"
               copyParams="cancelURL,cmCtxType,guid,specGuid,target,type">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/capture/captureWizProcessing"/>

        <uix:pageLayout 
             title="Create Baseline: Processing">

            <%@ include file="/database/global.jspf" %>

            <uix:header
                text="Create Baseline: Processing"
                icon="/em/images/processl.gif">

              <uix:borderLayout>
                <uix:left>
                  <uix:labeledFieldLayout columns="2" labelWidth="20%">
                    <uix:contents>
                      <uix:messagePrompt
                          promptBinding="DATABASE@dbUIMsg"/>
                      <uix:styledText
                          styleClass="OraDataText"
                          textBinding="target@captureBean@servletRequest"/>
<%-- 
    <uix:messagePrompt
         promptBinding="objectLabel@captureBean@servletRequest"/>
    <uix:styledText
         styleClass="OraDataText"
         textBinding="objectValue@captureBean@servletRequest"/
--%>
                      <uix:messagePrompt
                          promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                      <uix:styledText
                          styleClass="OraDataText"
                          textBinding="tgtUser@captureBean@servletRequest"/>
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:left>
                <uix:right>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout hAlign="right">
                      <uix:submitButton
                          name="event"
                          value="cancelCapture"
                          textBinding="CANCEL@dbUIMsg"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:right>
              </uix:borderLayout>

              <uix:tableLayout width="100%" hAlign="center">

                <uix:rowLayout>
                  <uix:separator/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="left">
                  <uix:flowLayout>
                    <uix:styledText 
                        styleClass="OraInstructionText"
                        text="Processing: Creating and Capturing Baseline"/>
                    <uix:styledText
                        styleClass="OraInstructionText"
                        text="This process may take up 15 minutes to complete."/>
                  </uix:flowLayout>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing
                            timeInterval="<%=processingPageInterval%>">
                          <uix:contents>
                            <uix:styledText
                                styleClass="OraProcessingStatusFixed"
                                text="Process is in progress."/>
                          </uix:contents>
                        </uix:processing>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

            <uix:contentFooter>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelCapture"
                    textBinding="CANCEL@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:contentFooter>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
