<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       captureWizReview.jsp
 *
 *      NOTES
 *       jsp for CM capture UI - Review page. 
 *       The key to the bean supporting the wizard
 *       is 'captureBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   10/24/07 - 
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      04/18/05 - pattern support 
 *    xshen      03/22/05 - add init param to review page 
 *    xshen      02/14/05 - remove cancel url from form 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/21/04 - ui changes 
 *    xshen      09/15/04 - fix block size to 10 for wizard 
 *    xshen      09/13/04 - ui review changes 
 *    xshen      09/10/04 - ui review changes 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      05/07/04 - ui changes
 *    xshen      04/30/04 - display with different mode 
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/17/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@captureBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="captureForm" 
               method="POST"
               destinationBinding="captureDestination@captureBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/capture/captureWizReview"/>

        <uix:pageLayout 
             titleBinding="titleString@captureBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@captureBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout width="100%">
                <uix:contents>
                  <%-- uix:messagePrompt
                      promptBinding="DATABASE@cmUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="target@captureBean@servletRequest"/ --%>
                  <uix:messagePrompt
                      promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="tgtUser@captureBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <!-- Review Capture Options -->
            <uix:tableLayout width="80%">
              <uix:contents>
                <uix:labeledFieldLayout labelWidth="30%">
                  <uix:contents>
                    <!-- Baseline Name -->
                    <uix:messagePrompt
                         promptBinding="BASELINE_NAME@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="newName@captureBean@servletRequest"/>

                    <!-- Database -->
                    <uix:messagePrompt
                         promptBinding="SOURCE_DATABASE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="target@captureBean@servletRequest"/>

                    <!-- Description -->
                    <uix:messagePrompt
                         promptBinding="DESCRIPTION@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="newDescription@captureBean@servletRequest"/>

                    <!-- Types: Only Shown if showReviewTypes is true -->
                    <uix:messagePrompt
                         promptBinding="OBJECTTYPES@dbUIMsg"
                         renderedBinding="showReviewTypes@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="selectedTypeString@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewTypes@specifyScopeBean@servletRequest"/>

                    <!-- Schemas: Only Shown if showReviewSchemas is true -->
                    <!-- when getObjectMode is false -->
                    <uix:messagePrompt
                         promptBinding="schemaPrompt@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewSchemas@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="selectedSchemaString@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewSchemas@specifyScopeBean@servletRequest"/>
                    <!-- Patterns: Only Shown if showPrefixPattern is true -->
                    <!-- when getObjectMode is false -->
                    <uix:messagePrompt
                         promptBinding="OBJNAME_STARTSWITH@cmUIMsg"
                         renderedBinding="showPrefixPattern@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="prefixInputString@specifyScopeBean@servletRequest"
                         renderedBinding="showPrefixPattern@specifyScopeBean@servletRequest"/>
      
                    <!-- Grants -->
                    <uix:messagePrompt
                         promptBinding="GRANTS_FOR_USERS_ROLES@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="grantString@captureBean@servletRequest"/>

                    <!-- Init Ora -->
                    <uix:messagePrompt
                         promptBinding="INITIALIZATION_PARAMETERS@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="initOraString@captureBean@servletRequest"/>

                  </uix:contents>
                </uix:labeledFieldLayout>        
              </uix:contents>
            </uix:tableLayout>

            <!-- Object Table: Only Shown if showReviewObjects is true -->

            <uix:header textBinding="OBJECTS_TO_INCLUDE@cmUIMsg" 
                        renderedBinding="showReviewObjects@specifyScopeBean@servletRequest">
              <uix:table width="70%"
                         summaryBinding="OBJECTS_TO_INCLUDE@cmUIMsg"
                         partialRenderMode="self"
                         id="selectedItemsTable"
                         name="selectedItemsTable"
                         alternateTextBinding="alternateText@specifyScopeBean@servletRequest"
                         formSubmitted="true"
                         valueBinding="value@specifyScopeBean@servletRequest"
                         maxValueBinding="maxValue@specifyScopeBean@servletRequest"
                         blockSize="10"
                         tableDataBinding="selectedItems@specifyScopeBean@servletRequest"
                         columnHeaderDataBinding="columnHeaders@specifyScopeBean@servletRequest" 
                         columnFormatsBinding="columnFormats@specifyScopeBean@servletRequest">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader textBinding="text"
                                              valueBinding="value"
                                              sortableBinding="sort"/>
                        </uix:columnHeaderStamp>
                        <uix:contents>
                          <uix:styledText textBinding="sname"/>
                          <uix:styledText textBinding="oname"/>
                          <uix:styledText textBinding="otype"/>
                        </uix:contents>
              </uix:table>
            </uix:header>
  
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    shortDescBinding="CANCEL@dbUIMsg"
                    name="event"
                    value="cancelCapture"
                    textBinding="CANCEL@dbUIMsg"/>
                <uix:navigationBar
                    name="captureNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxStepValue@captureBean@servletRequest"
                    valueBinding="stepValue@captureBean@servletRequest"
                    formSubmitted="true"
                    formName="captureForm"
                    destinationBinding="captureDestination@captureBean@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="finishCapture"
                    shortDescBinding="SUBMIT@dbUIMsg"
                    textBinding="SUBMIT@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
