<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       captureWizSource.jsp
 *
 *      NOTES
 *       jsp for CM capture UI - Select Source 
 *       The key to the bean supporting the wizard
 *       is 'captureBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   11/26/08 - ada input focus
 *    xshen      05/05/06 - cm-dbc support 
 *    xshen      05/13/05 - ada
 *    xshen      05/13/05 - short desc binding 
 *    xshen      03/29/05 - adding error binding 
 *    xshen      02/14/05 - fixing cancel url 
 *    xshen      02/11/05 - using page buttons include 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/13/04 - ui review changes
 *    xshen      09/10/04 - ui review changes 
 *    xshen      08/18/04 - lov intg 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      05/07/04 - ui changes
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/15/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<!-- Select Source database lov -->
<db:script src="/page/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@captureBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].newName.focus()">
      <db:form name="captureForm" 
               method="POST"
               destinationBinding="captureDestination@captureBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/capture/captureWizSource"/>
      <uix:formValue name="type" 
                     valueBinding="type@captureBean@servletRequest"/>
      <uix:formValue name="cancelURL" 
                     valueBinding="dbLoginCancelURL@servletRequest"/>
      <uix:switcher childNameBinding="enterpriseMode@captureBean@servletRequest">
        <uix:case name="false">
          <uix:formValue name="target" valueBinding="target@captureBean@servletRequest"/>
        </uix:case>
      </uix:switcher>

        <uix:pageLayout 
             titleBinding="titleString@captureBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@captureBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <uix:tableLayout width="100%">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer height="3"/>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:borderLayout>

                      <%-- Right side of borderLayout --%>
                      <uix:right>
                        <uix:contentContainer textBinding="OVERVIEW@cmUIMsg" width="400">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="OVERVIEW_MSG1@cmUIMsg"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:contentContainer>
                      </uix:right>

                      <%-- Inner Right: putting sufficient spacer --%>
                      <uix:innerRight>
                        <uix:tableLayout width="20%">
                          <uix:rowLayout>
                            <uix:spacer width="20"/>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:innerRight>

                      <%-- Contents of borderLayout --%>
                      <uix:contents>
			<uix:tableLayout width="90%">
                          <uix:contents>
			    <uix:labeledFieldLayout labelWidth="15%">
                              <uix:contents>
                                <uix:messageTextInput
                                     shortDescBinding="BASELINE_NAME@cmUIMsg"
                                     promptBinding="BASELINE_NAME@cmUIMsg"
                                     required="uiOnly"
                                     name="newName"
                                     columns="50"
                                     maximumLength="40"
                                     textBinding="newName@captureBean@servletRequest"
                                     messageBinding="(BASELINE_NAME@cmUIMsg)@messages@servletRequest"
                                     messageTypeBinding="(BASELINE_NAME@cmUIMsg)@messageTypes@servletRequest"/>
                            
                            <uix:switcher childNameBinding="enterpriseMode@captureBean@servletRequest">
                              <%-- enterprise mode --%>
                              <uix:case name="true">
                                <uix:messageLovField                                     
                                     promptBinding="SOURCE_DATABASE@cmUIMsg"
                                     required="uiOnly"
                                     id="target"
                                     name="target"
                                     columns="50"
                                     tipBinding="MUST_BE_9I_LATER@cmUIMsg"
                                     textBinding="target@captureBean@servletRequest"
                                     searchDescBinding="CLICK_TO_SELECT_DATABASE@cmUIMsg"
                                     onClick="preserveCase();startLov('target','ListDatabaseCM')"
                                     messageBinding="(DATABASE@cmUIMsg)@messages@servletRequest"
                                     messageTypeBinding="(DATABASE@cmUIMsg)@messageTypes@servletRequest"/>
                              </uix:case>
                            </uix:switcher>

                            <uix:switcher childNameBinding="enterpriseMode@captureBean@servletRequest">
                              <%-- database control mode --%>
                              <uix:case name="false">                                
                                <uix:messagePrompt promptBinding="SOURCE_DATABASE@cmUIMsg"/>
                              </uix:case>
                            </uix:switcher>

                              <%-- database control mode --%>
                            <uix:switcher childNameBinding="enterpriseMode@captureBean@servletRequest">
                              <uix:case name="false">                                
                                <uix:styledText styleClass="OraDataText" 
                                                textBinding="target@captureBean@servletRequest"/>
                              </uix:case>
                            </uix:switcher>

				<uix:messageTextInput
                                     promptBinding="DESCRIPTION@cmUIMsg"
                                     shortDescBinding="DESCRIPTION@cmUIMsg"
                                     rows="4"
                                     name="newDescription"
			             maximumLength="2000"
                                     columns="52"
                                     textBinding="newDescription@captureBean@servletRequest"/>
			      </uix:contents>
			    </uix:labeledFieldLayout>
                          </uix:contents>
			</uix:tableLayout>
                      </uix:contents>
                    </uix:borderLayout>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <%@ include file="/database/changemgr/capture/captureWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
