<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       cmConfirm.jsp
 *
 *      NOTES
 *       jsp launched from various CM page for a confirmation
 *       of an action to be taken.  The bean name is 'cmConfirmBean'
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      01/20/05 - adding browser title 
 *    xshen      01/06/05 - fix post cabo migration issues 
 *    xshen      08/16/04 - xshen_changemgr_addconfir_rangeacc_verfmt_validate
 *    xshen      08/11/04 - using instruction text strong per ui guide
 *    xshen      08/09/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

        <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

            <uix:header iconBinding="confirmationIcon@cmConfirmBean@servletRequest" 
			textBinding="CONFIRMATION@cmUIMsg">
              <uix:tableLayout width="100%">
	        <uix:rowLayout width="100%" vAlign="bottom">
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                       textBinding="mainConfirmationStr@cmConfirmBean@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>

            <uix:spacer height="20"/>

            <!-- Yes and No Buttons -->
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="NO@dbUIMsg"
                            shortDescBinding="NO@dbUIMsg"
                            destinationBinding="actNoDest@cmConfirmBean@servletRequest"/>
                <uix:button textBinding="YES@dbUIMsg"
                            shortDescBinding="YES@dbUIMsg"
                            destinationBinding="actYesDest@cmConfirmBean@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
