<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       cmListOfValues.jsp
 *
 *      NOTES
 *       Select from a list of available schemas (may support more types)
 *       The bean key is 'cmListOfValuesBean'
 *        In CM on the same (launching) page we might deal with 2 
 *        db targets, or only repository, or 1 db target 1 repository.
 *        It is infeasible to use both generic LOV (db and core) 
 *        versions on the same page and cover all the cases.
 *        This version deals with all combinations but is made CM specific.
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      10/01/04 - xshen_changemgr_schmmap_revised-1001
 *    xshen      10/01/04 - adding specGuid form value to access cached 
 *                          compare obj 
 *    xshen      09/30/04 - Created.
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="titleStr@cmListOfValuesBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:pageLayout>
       <uix:contents>
          <uix:listOfValues titleBinding="shortTitle@cmListOfValuesBean@servletRequest"
               searchTextBinding="searchFieldValue@cmListOfValuesBean@servletRequest">
            <uix:formValue name="pageName" 
                           value="/database/changemgr/cmListOfValues"/>
            <uix:formValue name="specGuid" 
                           valueBinding="specGuid@cmListOfValuesBean@servletRequest"/>
            <uix:headerInstructions>
              <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="headerInstruction@cmListOfValuesBean@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraInstructionTextStrong"
                                textBinding="comparisonSourceName@cmListOfValuesBean@servletRequest"/>
              </uix:flowLayout>
            </uix:headerInstructions>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="TO_FIND_ITEM@dbUIMsg"/>
            </uix:searchInstructions>
            <uix:contents>
              <uix:table name="listOfValuesTable"
                         summaryBinding="RESULTS@cmUIMsg"
                         alternateTextBinding="NO_SCHEMAS_AVAILABLE@cmUIMsg"
			 tableDataBinding="listOfValuesTable@cmListOfValuesBean@servletRequest"
                         columnHeaderDataBinding="columnHeaders@cmListOfValuesBean@servletRequest"
                         columnFormatsBinding="columnFormats@cmListOfValuesBean@servletRequest"
                         valueBinding="value@cmListOfValuesBean@servletRequest" 
                         maxValueBinding="maxValue@cmListOfValuesBean@servletRequest"
                         width="100%"
                         blockSize="10"
                         formSubmitted="true"
                         proxied="true">
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" 
                                         sortableBinding="sort"/>
                   </uix:columnHeaderStamp>

                   <uix:contents>
                     <uix:styledText textBinding="sname"/>
                     <uix:formValue name="sname" valueBinding="sname"/>
                   </uix:contents>
                   <uix:tableSelection>
                    <uix:singleSelection 
                         shortDescBinding="SELECT@dbUIMsg" 
                         selectedIndex="0"/>
                   </uix:tableSelection>
              </uix:table>
          </uix:contents>
        </uix:listOfValues>
      </uix:contents>
     </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

