<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       cmObjectList.jsp
 *
 *      NOTES
 *       jsp for a list of objects in a baseline / comparison
 *       The bean key of the supporting model
 *       is 'cmObjListBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      06/29/05 - support bl obj history 
 *    xshen      05/24/05 - adding save to file to baseline as well 
 *    xshen      05/13/05 - ada
 *    xshen      05/09/05 - bulk ignore and annotate support 
 *    xshen      05/06/05 - rowlayout
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      05/02/05 - add save to csv file support 
 *    mpawelko   04/25/05 - bug 3269618: use VIEW_BUTTON for submitButton 
 *    xshen      03/31/05 - change to table action 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      01/11/05 - fix relative version copy params 
 *    xshen      10/10/04 - support printable report 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/17/04 - ui review changes 
 *    xshen      08/20/04 - lov work
 *    xshen      08/10/04 - fix single select for comparison mode 
 *    xshen      07/14/04 - move copy param to java code. 
 *    xshen      06/17/04 - support comparison obj list
 *    xshen      05/12/04 - add generate DDL button
 *    xshen      05/07/04 - ui changes
 *    xshen      04/12/04 - add copy params
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/29/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@cmObjListBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="cmObjListForm" 
               method="POST"
               destinationBinding="cmObjListDestination@cmObjListBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,specGuid,specType,target,type,ctxType">
      <uix:formValue name="guid" valueBinding="guid@cmObjListBean@servletRequest"/>
      <uix:formValue name="version" valueBinding="version@cmObjListBean@servletRequest"/>
      <uix:formValue name="pageName" 
                     value="/database/changemgr/cmObjectList"/>

        <uix:pageLayout 
             titleBinding="titleString@cmObjListBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   
        <%@ include file="/database/changemgr/listComm.jspf" %>
  
<!-- Begin Search Field -->

<!-- Select Schemas lov -->
<db:script src="/page/LOV.js"/>


<uix:header textBinding="OBJECTS@cmUIMsg">
<uix:stackLayout>
  <uix:contents>
    <uix:tableLayout cellSpacing="5">
      <uix:contents>
        <uix:rowLayout>
          <uix:contents>

            <!-- Object Type -->
            <uix:cellFormat>
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt promptBinding="OBJECT_TYPE@dbUIMsg"/>
                    <uix:choice name="searchType"
                                shortDescBinding="OBJECT_TYPE@dbUIMsg"
                                id="searchType"
                                selectedValueBinding="searchType@listCommBean@servletRequest">
                      <uix:contents childDataBinding="searchTypes@listCommBean@servletRequest">
                        <uix:option textBinding="text" 
                                    valueBinding="value"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

            <!-- Schemas -->
            <uix:cellFormat wrappingDisabled="true">
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt promptBinding="SCHEMA@dbUIMsg"/>
	            <!-- Use Baseline List LOV descriptor -->
                    <uix:lovField shortDescBinding="SCHEMA@dbUIMsg"
                                  id="searchSchema"
                                  renderedBinding="baselineType@listCommBean@servletRequest"
                                  name="searchSchema"
                                  columns="50"
                                  textBinding="searchSchema@listCommBean@servletRequest"
                                  searchDescBinding="CLICK_TO_SELECT_SCHEMA@cmUIMsg"
                                  onClick="preserveCase();setBindSqlParm('guid');setBindSqlParm('version');setBindSqlParm('version');startLov('searchSchema','ListSchemaBaseline')"/>
	            <!-- Use Comparison List LOV descriptor -->
                    <uix:lovField shortDescBinding="SCHEMA@dbUIMsg"
                                  id="searchSchema"
                                  renderedBinding="comparisonType@listCommBean@servletRequest"
                                  name="searchSchema"
                                  columns="50"
                                  textBinding="searchSchema@listCommBean@servletRequest"
                                  searchDescBinding="CLICK_TO_SELECT_SCHEMA@cmUIMsg"
                                  onClick="preserveCase();setBindSqlParm('guid');setBindSqlParm('version');setBindSqlParm('version');startLov('searchSchema','ListSchemaComparison')"/>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

            <!-- Object Names -->
            <uix:cellFormat>
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt promptBinding="OBJECT_NAME@dbUIMsg"/>
                    <uix:textInput id="searchObjectName"
                                   name="searchObjectName"
                                   shortDescBinding="ENTER_OBJECT_NAME@dbUIMsg"
                                   columns="50"
                                   textBinding="searchObjectName@listCommBean@servletRequest"/>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

            <uix:cellFormat>
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt prompt=" "/>
                    <uix:spacer height="14"/>
                    <uix:submitButton name="event"
                                      value="searchCMObject"
                                      shortDescBinding="GO@dbUIMsg"
                                      textBinding="GO@dbUIMsg"/>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

          </uix:contents>
        </uix:rowLayout>
      </uix:contents>
    </uix:tableLayout>
  </uix:contents>
</uix:stackLayout>

            <!-- Begin Search Results -->
             <uix:separator/>

           <!-- Export to CSV file only comparison -->
           <uix:tableLayout width="100%">
    	     <!-- Show Filter : only for comparison -->
            <uix:rowLayout vAlign="top" width="100%">
              <uix:cellFormat hAlign="left" width="1"
                   renderedBinding="comparisonType@cmObjListBean@servletRequest">
               <uix:messageChoice name="showOption" 
                    id="showOption"
                    promptBinding="SHOW@cmUIMsg"
  	            onChange="submitForm('cmObjListForm',true,{'event':'filterResults'})"
                    selectedValueBinding="showOption@cmObjListBean@servletRequest">
                 <uix:contents 
                      childDataBinding="showOptions@cmObjListBean@servletRequest">
                   <uix:option textBinding="text" valueBinding="value"/>
                 </uix:contents>
               </uix:messageChoice>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" width="1"
                   renderedBinding="comparisonType@cmObjListBean@servletRequest">
               <uix:choice name="showIgnoredOption"
                    shortDescBinding="SHOW@cmUIMsg"
                    id="showIgnoredOption"
  	            onChange="submitForm('cmObjListForm',true,{'event':'filterIgnoredResults'})"
                    selectedValueBinding="showIgnoredOption@cmObjListBean@servletRequest">
                <uix:contents>
                 <uix:option textBinding="RESULTS@cmUIMsg" 
                             value="RESULTS"/>
                 <uix:option textBinding="INCLUDING_IGNORED@cmUIMsg" 
                             value="INCLUDING_IGNORED"/>
                </uix:contents>
               </uix:choice>
              </uix:cellFormat> 
              <uix:cellFormat hAlign="right">
                <uix:button textBinding="SAVE_TO_FILE@cmUIMsg"
                     shortDescBinding="SAVE_TO_FILE@cmUIMsg"
                     destinationBinding="exportToCSVURL@cmObjListBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
           </uix:tableLayout>

           <!-- Comparison Table -->
           <uix:switcher childNameBinding="comparisonType@cmObjListBean@servletRequest">
            <uix:case name="true">   
             <oem:table width="90%"                        
                        name="objListTable"
                        summaryBinding="RESULTS@cmUIMsg"                         
                        destinationBinding="cmObjListDestination@cmObjListBean@servletRequest"
                        blockSize="25"
                        beanKey="cmObjListBean"
                        formSubmitted="true"
                        dataSourceProp="objListTable"
                        alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg">
                  <uix:tableSelection>
                    <uix:multipleSelection 
                         shortDescBinding="SELECT@dbUIMsg"
                         selectionBinding="multiSelection@cmObjListBean@servletRequest"
                         selectedBinding="selected">
                      <uix:submitButton
                           name="event"
                           value="addComments"
                           shortDescBinding="ADD_COMMENT@cmUIMsg"
                           textBinding="ADD_COMMENT@cmUIMsg"/>
                      <uix:submitButton
                           name="event"
                           value="ignoreResult"
                           shortDescBinding="IGNORE_RESULT@cmUIMsg"
                           textBinding="IGNORE_RESULT@cmUIMsg"/>
                      <uix:submitButton
                           name="event"
                           value="undoIgnoreResult"
                           disabledBinding="disableUndoIgnore@cmObjListBean@servletRequest"
                           shortDescBinding="UNDO_IGNORE_RESULT@cmUIMsg"
                           textBinding="UNDO_IGNORE_RESULT@cmUIMsg"/>
                    </uix:multipleSelection>
                  </uix:tableSelection>                         
              </oem:table>
             </uix:case>

         <!-- Baseline Table  -->
           <uix:case name="false">
             <oem:table width="80%"                        
                        name="objListTable"
                        summaryBinding="RESULTS@cmUIMsg"                         
                        destinationBinding="cmObjListDestination@cmObjListBean@servletRequest"
                        blockSize="25"
                        beanKey="cmObjListBean"
                        formSubmitted="true"
                        dataSourceProp="objListTable"
                        alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg">
                  <uix:tableSelection>
                    <uix:singleSelection 
                         shortDescBinding="SELECT@dbUIMsg"
                         selectedIndexBinding="selectedIndex@cmObjListBean@servletRequest">
                      <uix:submitButton
                           name="event"
                           value="viewBLObject"
                           shortDescBinding="VIEW_BUTTON@dbUIMsg"
                           textBinding="VIEW_BUTTON@dbUIMsg"/>
                      <uix:submitButton
                           name="event"
                           value="viewBLObjHistory"
                           shortDescBinding="VIEW_VERSION_HIST@cmUIMsg"
                           textBinding="VIEW_VERSION_HIST@cmUIMsg"/>
                      <uix:submitButton
                           name="event"
                           value="generateObjectDDL"
                           shortDescBinding="GENERATE_DDL@cmUIMsg"
                           textBinding="GENERATE_DDL@cmUIMsg"/>
                    </uix:singleSelection>
                  </uix:tableSelection>                         
              </oem:table>
             </uix:case>
            </uix:switcher>

            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="PRINTABLE_PAGE@cmUIMsg"
                                  shortDescBinding="PRINTABLE_PAGE@cmUIMsg"
                                  name="event"
                                  value="prntblPage"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
