<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       compareWizAddScopeItems.jsp
 *
 *      NOTES
 *       jsp for CM compare UI - Add Scope Spec Items.
 *       Launched from 'Add' on Comparison wizard. 
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      03/14/06 - bug 5090192 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/28/04 - adding instruction for exclude mode 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/07/04 - support exclude mode for comparison 
 *    xshen      08/20/04 - remove cancel URL 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      08/12/04 - use summary ui name 
 *    xshen      06/17/04 - xshen_changemgr_compareui
 *    xshen      06/15/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@compareBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="compareForm" 
               method="POST"
               destinationBinding="compareDestination@compareBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/compare/compareWizAddScopeItems"/>
      <uix:formValue name="event" 
                     value="addItemsSearch"/>

        <uix:pageLayout 
             titleBinding="titleString@compareBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@compareBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="RIGHT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="OPTIONS@cmUIMsg" disabled="true"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg" disabled="true"/>
                  <uix:link textBinding="REVIEW@cmUIMsg" disabled="true"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:rowLayout width="100%">
               <uix:labeledFieldLayout>
                <uix:contents>
                  <uix:messagePrompt
                       promptBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:styledText
                       styleClass="OraDataText"
                       textBinding="leftSummaryDisplay@compareBean@servletRequest"/>
                  <uix:messagePrompt
		       renderedBinding="leftSourceDatabase@compareBean@servletRequest"
                       promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
		       renderedBinding="leftSourceDatabase@compareBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="leftTgtUser@compareBean@servletRequest"/>
                </uix:contents>
               </uix:labeledFieldLayout>
               <uix:labeledFieldLayout renderedBinding="comparisonExclude@addScopeItems@specifyScope@compareBean@servletRequest">
                <uix:contents>
                  <uix:messagePrompt promptBinding="RIGHT_SOURCE@cmUIMsg"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="rightSummaryDisplay@compareBean@servletRequest"/>
                  <uix:messagePrompt renderedBinding="rightSourceDatabase@compareBean@servletRequest"
		                     promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText renderedBinding="rightSourceDatabase@compareBean@servletRequest"
		            	     styleClass="OraDataText"
                                     textBinding="rightTgtUser@compareBean@servletRequest"/>
                </uix:contents>
               </uix:labeledFieldLayout>
             </uix:rowLayout>
            </uix:pageStatus>   

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

	    <!-- Instruction only in Exclude Mode -->
            <uix:rowLayout width="100%" 
                           renderedBinding="excludeMode@compareBean@servletRequest">
              <uix:messagePrompt promptBinding="OBJECTS_ADD_EXCLUDE_SCHEMAS@cmUIMsg"/>
            </uix:rowLayout>
	    <!-- Instruction only in Object Mode for comparison -->
            <uix:rowLayout width="100%" 
                           renderedBinding="objectMode@compareBean@servletRequest">
              <uix:messagePrompt promptBinding="SELECT_OBJ_FROM_LEFT@cmUIMsg"/>
            </uix:rowLayout>

            <!-- Add Scope Items Included Page -->
            <%@ include file="/database/changemgr/addScopeItems.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
