<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       compareWizJobOpt.jsp
 *
 *      NOTES
 *       jsp for CM compare UI - Job Options
 *       The key to the bean supporting the wizard
 *       is 'compareBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      02/14/05 - remove cancel url from form 
 *    xshen      02/11/05 - fix cancel compare 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      06/28/04 - set unvalidate true (done in the backend)
 *    xshen      06/17/04 - xshen_changemgr_compareui
 *    xshen      06/15/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@compareBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="compareForm" 
               method="POST"
               destinationBinding="compareDestination@compareBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/compare/compareWizJobOpt"/>

        <uix:pageLayout 
             titleBinding="titleString@compareBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@compareBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="RIGHT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>
            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <%@ include file="/database/changemgr/compare/bipartitePS.jspf" %>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <!-- Specify Credential: Use our own credential widget until 
              -- one available from sdk, both jspf and bean
              -->
            <%@ include file="/database/changemgr/cmCreds.jspf"%>

            <!-- Specify Schedule -->
            <uix:header textBinding="SCHEDULE@dbUIMsg">
              <%@ include file="/sdk/schedule/schedule.jspf"%>
            </uix:header>

            <%@ include file="/database/changemgr/compare/compareWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
