<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       compareWizLHS.jsp
 *
 *      NOTES
 *       jsp for CM compare UI - Select Left Source 
 *       The key to the bean supporting the wizard
 *       is 'compareBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   11/26/08 - ada input focus
 *    xshen      12/04/06 - oac
 *    xshen      05/12/06 - cm-dbc support 
 *    xshen      05/13/05 - ada
 *    xshen      05/13/05 - short desc binding 
 *    xshen      03/29/05 - adding error binding 
 *    xshen      02/14/05 - fixing cancel url 
 *    xshen      02/11/05 - fix cancel compare 
 *    xshen      01/18/05 - support synchronizing capture with compare 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/13/04 - ui review changes 
 *    xshen      09/10/04 - ui review changes 
 *    xshen      08/23/04 - support cm specific lov 
 *    xshen      08/18/04 - lov work 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      08/12/04 - add version format 
 *    xshen      06/17/04 - xshen_changemgr_compareui
 *    xshen      06/15/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<!-- Select Database LOV -->
<db:script src="/page/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@compareBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="document.forms[0].newName.focus()">
      <db:form name="compareForm" 
               method="POST"
               destinationBinding="compareDestination@compareBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/compare/compareWizLHS"/>
      <uix:formValue name="type" 
                     valueBinding="leftSourceTargetType@compareBean@servletRequest"/>
      <uix:formValue name="cancelURL" 
                     valueBinding="dbLoginCancelURL@servletRequest"/>
      <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
        <uix:case name="false">
          <uix:formValue name="target" valueBinding="leftDBName@compareBean@servletRequest"/>
        </uix:case>
      </uix:switcher>

        <uix:pageLayout 
             titleBinding="titleString@compareBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@compareBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="RIGHT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>
            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <uix:tableLayout width="100%">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer height="3"/>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:borderLayout>

                      <%-- Right side of borderLayout --%>
                      <uix:right>
                        <uix:contentContainer
                            textBinding="OVERVIEW@cmUIMsg"
                            width="400">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="COMPARE_OVERVIEW_MSG1@cmUIMsg"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:contentContainer>
                      </uix:right>

                      <%-- Inner Right: putting sufficient spacer --%>
                      <uix:innerRight>
                        <uix:tableLayout width="10%">
                          <uix:rowLayout>
                            <uix:spacer width="10"/>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:innerRight>

                      <%-- Contents of borderLayout --%>
                      <uix:contents>
			<uix:labeledFieldLayout fieldWidth="80%" labelWidth="120">
                          <uix:contents>
                            <uix:messageTextInput
                                 promptBinding="COMPARISON_NAME@cmUIMsg"
                                 shortDescBinding="COMPARISON_NAME@cmUIMsg"
                                 required="uiOnly"
                                 name="newName"
                                 maximumLength="30"
                                 columns="44"
                                 textBinding="newName@compareBean@servletRequest"
                                 messageBinding="(COMPARISON_NAME@cmUIMsg)@messages@servletRequest"
                                 messageTypeBinding="(COMPARISON_NAME@cmUIMsg)@messageTypes@servletRequest"/>

		            <uix:messageTextInput
                                 promptBinding="DESCRIPTION@cmUIMsg"
                                 shortDescBinding="DESCRIPTION@cmUIMsg"
                                 name="newDescription"
                                 columns="46"
				 rows="3"
                                 textBinding="newDescription@compareBean@servletRequest"/>

			  </uix:contents>
			</uix:labeledFieldLayout>

		        <uix:rowLayout width="100%">
                          <uix:contents>
			    <uix:spacer height="4"/>
                          </uix:contents>
			</uix:rowLayout>

		        <uix:rowLayout width="100%">
                          <uix:contents>
			    <uix:messagePrompt 
                                 promptBinding="SPECIFY_LEFT_SOURCE@cmUIMsg"/>
                          </uix:contents>
			</uix:rowLayout>

		        <uix:rowLayout width="100%">
                          <uix:contents>
			    <uix:spacer height="4"/>
                          </uix:contents>
			</uix:rowLayout>

		        <uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:radioButton name="leftSourceType" 
                                 value="D" 
                                 selectedValueBinding="leftSourceType@compareBean@servletRequest"
                                 shortDescBinding="RUNNING_INSTANCE@cmUIMsg"
                                 textBinding="RUNNING_INSTANCE@cmUIMsg"/>
                          </uix:contents>
			</uix:rowLayout>

                        <uix:labeledFieldLayout fieldWidth="80%" labelWidth="120">
                          <uix:contents>
                            <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
                              <uix:case name="true">
                                <uix:messageLovField
                                 promptBinding="DATABASE_TYPE@cmUIMsg"
                                 shortDescBinding="DATABASE_TYPE@cmUIMsg"
                                 id="target"
                                 name="target"
                                 columns="44"
                                 tipBinding="MUST_BE_9I_LATER@cmUIMsg"
                                 textBinding="leftDBName@compareBean@servletRequest"
                                 searchDescBinding="CLICK_TO_SELECT_DATABASE@cmUIMsg"
                                 onClick="preserveCase();startLov('target','ListDatabaseCM')"
                                 messageBinding="(DATABASE@cmUIMsg)@messages@servletRequest"
                                 messageTypeBinding="(DATABASE@cmUIMsg)@messageTypes@servletRequest"/>
                              </uix:case>
                            </uix:switcher>
                            <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
                              <uix:case name="false">
                                <uix:messagePrompt promptBinding="SOURCE_DATABASE@cmUIMsg"/>
                              </uix:case>
                            </uix:switcher>
                            <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
                              <uix:case name="false">
                                <uix:styledText styleClass="OraDataText" 
                                                textBinding="leftDBName@compareBean@servletRequest"/>
                              </uix:case>
                            </uix:switcher>

                              </uix:contents>
                            </uix:labeledFieldLayout>

		        <uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:radioButton name="leftSourceType" 
                                 value="B" 
                                 selectedValueBinding="leftSourceType@compareBean@servletRequest"
                                 shortDescBinding="SAVED_BASELINE_VERSION@cmUIMsg"
                                 textBinding="SAVED_BASELINE_VERSION@cmUIMsg"/>
                          </uix:contents>
			</uix:rowLayout>

			<uix:labeledFieldLayout fieldWidth="80%" labelWidth="120">
                          <uix:contents>
                            <uix:messageLovInput 
                                 promptBinding="BASELINE_NFMT@cmUIMsg"
                                 shortDescBinding="BASELINE_NFMT@cmUIMsg"
                                 tipBinding="SAVED_BASELINE_VERSION_TIP@cmUIMsg"
                                 id="leftBLName"
                                 name="leftBLName"
                                 columns="44"
                                 textBinding="leftBLName@compareBean@servletRequest"
                                 searchDescBinding="CLICK_TO_SELECT_BASELINE@cmUIMsg"
                                 destinationBinding="selectBLVersionDest@compareBean@servletRequest"
                                 messageBinding="(BASELINE_NAME@cmUIMsg)@messages@servletRequest"
                                 messageTypeBinding="(BASELINE_NAME@cmUIMsg)@messageTypes@servletRequest"/>
                            <!-- Capture Before Compare -->
                            <uix:messagePrompt prompt=""/>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:checkBox name="leftCaptureFirst"
                                 textBinding="CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg"
                                 disabledBinding="leftCaptureFirstDisabled@compareBean@servletRequest"
                                 shortDescBinding="CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg"
                                 checkedBinding="leftCaptureFirst@compareBean@servletRequest"/>
                                <uix:messageText
                                     messageBinding="(CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg)@messages@servletRequest"
                                     messageTypeBinding="(CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg)@messageTypes@servletRequest"/>     
                              </uix:contents>
                            </uix:stackLayout>
	  		  </uix:contents>
		        </uix:labeledFieldLayout>

                      </uix:contents>
                    </uix:borderLayout>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <%@ include file="/database/changemgr/compare/compareWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
