<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       compareWizObject.jsp
 *
 *      NOTES
 *       jsp for CM compare UI - Compare Options
 *       The key to the bean supporting the wizard
 *       is 'compareBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      02/15/07 - XbranchMerge xshen_cm_bugs from st_emdbsa_11.1
 *    xshen      12/04/06 - oac
 *    xshen      06/16/05 - change ignore partition text 
 *    xshen      05/16/05 - ignore partition 
 *    xshen      04/27/05 - add ignore table column positions 
 *    xshen      02/14/05 - remove cancel url from form 
 *    xshen      02/11/05 - fix cancel compare 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      10/01/04 - changing id 
 *    xshen      09/28/04 - change to label value pairs 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      06/17/04 - xshen_changemgr_compareui
 *    xshen      06/15/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@compareBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="compareForm" 
               method="POST"
               destinationBinding="compareDestination@compareBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/compare/compareWizOption"/>

        <uix:pageLayout 
             titleBinding="titleString@compareBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@compareBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="RIGHT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>
            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <%@ include file="/database/changemgr/compare/bipartitePS.jspf" %>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>
 
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" 
                                wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="STORAGE@cmUIMsg"/>
 		</uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left" >
                  <uix:stackLayout>
                    <uix:checkBox name="ignorePhysical"
                                shortDescBinding="IGNORE_PHYSICAL@cmUIMsg"
                                textBinding="IGNORE_PHYSICAL@cmUIMsg"
                                checkedBinding="ignorePhysical@compareBean@servletRequest"/>
                    <uix:styledText textBinding="IGNORE_PHYSICAL_TIP@cmUIMsg" styleClass="OraInlineInfoText"/>

                    <uix:checkBox name="ignoreTbsp"
                                shortDescBinding="IGNORE_TABLESPACE@cmUIMsg"
                                textBinding="IGNORE_TABLESPACE@cmUIMsg"
                                checkedBinding="ignoreTbsp@compareBean@servletRequest"/>
                    <uix:styledText textBinding="IGNORE_TABLESPACE_TIP@cmUIMsg" styleClass="OraInlineInfoText"/>
 	          </uix:stackLayout>
     	        </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="MATCH_CONSTRAINTS@cmUIMsg"/>
 		</uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left">
                  <uix:stackLayout>
                    <uix:radioButton name="matchCons" 
                                   value="BY_DEFINITION" 
                                   selectedValueBinding="matchCons@compareBean@servletRequest"
                                   shortDescBinding="BY_DEFINITION@cmUIMsg"
                                   textBinding="BY_DEFINITION@cmUIMsg"/>
                    <uix:flowLayout>
                      <uix:spacer width="16"/>
                      <uix:stackLayout>
                        <uix:checkBox name="reportNameDiff"
                                    shortDescBinding="REPORT_NAME_DIFF@cmUIMsg"
                                    textBinding="REPORT_NAME_DIFF@cmUIMsg"
                                    checkedBinding="reportNameDiff@compareBean@servletRequest"/>
                      </uix:stackLayout>
                    </uix:flowLayout>
                    <uix:radioButton name="matchCons" 
                                   value="BY_NAME" 
                                   selectedValueBinding="matchCons@compareBean@servletRequest"
                                   shortDescBinding="BY_NAME@cmUIMsg"
                                   textBinding="BY_NAME@cmUIMsg"/>
                    <uix:tip>
                      <uix:styledText textBinding="BY_NAME_TIP@cmUIMsg"/>
                    </uix:tip>
                  </uix:stackLayout>
 		</uix:cellFormat>
              </uix:rowLayout>

	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" 
                                wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="PART_OBJECTS@cmUIMsg"/>
 		</uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left" >
                   <uix:stackLayout>
                    <uix:checkBox name="ignorePartition"
                              shortDescBinding="IGNORE_HIGH_VALUES@cmUIMsg"
                              textBinding="IGNORE_HIGH_VALUES@cmUIMsg"
                              checkedBinding="ignorePartition@compareBean@servletRequest"/>
                    <uix:styledText textBinding="IGNORE_HIGH_VALUES_TIP@cmUIMsg" styleClass="OraInlineInfoText"/>
                  </uix:stackLayout>
 		</uix:cellFormat>
	      </uix:rowLayout>

	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" 
                                wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="SRC_TYPE_OBJS@cmUIMsg"/>
 		</uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left" >
                  <uix:stackLayout>
                    <uix:checkBox name="logicalSQL"
                              shortDescBinding="LOGICAL_SQL_COMPARE@cmUIMsg"
                              textBinding="LOGICAL_SQL_COMPARE@cmUIMsg"
                              checkedBinding="logicalSQL@compareBean@servletRequest"/>
                    <uix:styledText textBinding="LOGICAL_SQL_COMPARE_TIP@cmUIMsg" styleClass="OraInlineInfoText"/>
                  </uix:stackLayout>
 		</uix:cellFormat>
	      </uix:rowLayout>

	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" 
                                wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="STATISTICS@cmUIMsg"/>
 		</uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left" >
                  <uix:stackLayout>
                    <uix:checkBox name="compareStats"
                              shortDescBinding="COMPARE_STATS@cmUIMsg"
                              textBinding="COMPARE_STATS@cmUIMsg"
                              checkedBinding="compareStats@compareBean@servletRequest"/>
                    <uix:styledText textBinding="COMPARE_STATS_TIP@cmUIMsg" styleClass="OraInlineInfoText"/>
                  </uix:stackLayout>
                </uix:cellFormat>
	      </uix:rowLayout>

	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" 
                                wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="OTHER_OPTIONS@cmUIMsg"/>
 		</uix:cellFormat>
                <uix:spacer width="5"/>
                <uix:cellFormat hAlign="left" >
                    <uix:checkBox name="ignoreTblColNum"
                              shortDescBinding="IGNORE_TBLCOL_NUM@cmUIMsg"
                              textBinding="IGNORE_TBLCOL_NUM@cmUIMsg"
                              checkedBinding="ignoreTblColNum@compareBean@servletRequest"/>
                 </uix:cellFormat>
              </uix:rowLayout>

	    </uix:tableLayout>

            <%@ include file="/database/changemgr/compare/compareWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
