<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       compareWizRHS.jsp
 *
 *      NOTES
 *       jsp for CM compare UI - Select Right Source 
 *       The key to the bean supporting the wizard
 *       is 'compareBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   11/26/08 - ada input focus
 *    xshen      12/04/06 - oac
 *    xshen      05/12/06 - cm-dbc support 
 *    xshen      05/13/05 - ada
 *    xshen      03/29/05 - adding error binding 
 *    xshen      02/14/05 - fixing cancel url 
 *    xshen      02/11/05 - fix cancel compare 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      01/18/05 - support synchronizing capture with compare 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/13/04 - ui review changes 
 *    xshen      08/23/04 - support cm specific lov 
 *    xshen      08/18/04 - lov work 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      08/12/04 - add version format 
 *    xshen      06/29/04 - fix typo
 *    xshen      06/17/04 - xshen_changemgr_compareui
 *    xshen      06/15/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<!-- Select Database LOV -->
<db:script src="/page/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@compareBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].target.focus()">
      <db:form name="compareForm" 
               method="POST"
               destinationBinding="compareDestination@compareBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/compare/compareWizRHS"/>
      <uix:formValue name="type" 
                     valueBinding="rightSourceTargetType@compareBean@servletRequest"/>
      <uix:formValue name="cancelURL" 
                     valueBinding="dbLoginCancelURL@servletRequest"/>
      <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
        <uix:case name="false">
          <uix:formValue name="target" valueBinding="rightDBName@compareBean@servletRequest"/>
        </uix:case>
      </uix:switcher>

        <uix:pageLayout 
             titleBinding="titleString@compareBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@compareBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="RIGHT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>
            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout width="100%">
                <uix:contents>
                  <uix:messagePrompt
                       promptBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:styledText
                       styleClass="OraDataText"
                       textBinding="leftSummaryDisplay@compareBean@servletRequest"/>

                  <uix:messagePrompt 
		       renderedBinding="leftSourceDatabase@compareBean@servletRequest"
                       promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
		       renderedBinding="leftSourceDatabase@compareBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="leftTgtUser@compareBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

		<uix:rowLayout width="100%">
                  <uix:contents>
                    <uix:messagePrompt 
                         promptBinding="SPECIFY_RIGHT_SOURCE@cmUIMsg"/>
                  </uix:contents>
		</uix:rowLayout>

		<uix:rowLayout width="100%">
                  <uix:contents>
		    <uix:spacer height="4"/>
                  </uix:contents>
		</uix:rowLayout>

		<uix:rowLayout width="100%">
                  <uix:contents>
                    <uix:radioButton name="rightSourceType" 
                                     value="D" 
                                     selectedValueBinding="rightSourceType@compareBean@servletRequest"
                                     shortDescBinding="RUNNING_INSTANCE@cmUIMsg"
                                     textBinding="RUNNING_INSTANCE@cmUIMsg"/>
                  </uix:contents>
		</uix:rowLayout>

                <uix:labeledFieldLayout labelWidth="100">
                  <uix:contents>
                    <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
                       <uix:case name="true">
                        <uix:messageLovField
                             promptBinding="DATABASE_TYPE@cmUIMsg"
                             tipBinding="MUST_BE_9I_LATER@cmUIMsg"
                             id="target"
                             name="target"
                             columns="44"
                             textBinding="rightDBName@compareBean@servletRequest"
                             searchDescBinding="CLICK_TO_SELECT_DATABASE@cmUIMsg"
                             onClick="preserveCase();startLov('target','ListDatabaseCM')"
                             messageBinding="(DATABASE@cmUIMsg)@messages@servletRequest"
                             messageTypeBinding="(DATABASE@cmUIMsg)@messageTypes@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                      <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
                        <uix:case name="false">
                           <uix:messagePrompt promptBinding="SOURCE_DATABASE@cmUIMsg"/>
                        </uix:case>
                      </uix:switcher>
                      <uix:switcher childNameBinding="enterpriseMode@compareBean@servletRequest">
                        <uix:case name="false">
                           <uix:styledText styleClass="OraDataText" 
                                           textBinding="rightDBName@compareBean@servletRequest"/>
                        </uix:case>
                      </uix:switcher>

	  	    </uix:contents>
		  </uix:labeledFieldLayout>

		  <uix:rowLayout width="100%">
                    <uix:contents>
                      <uix:radioButton name="rightSourceType" 
                                       value="B" 
                                       selectedValueBinding="rightSourceType@compareBean@servletRequest"
                                       shortDescBinding="SAVED_BASELINE_VERSION@cmUIMsg"
                                       textBinding="SAVED_BASELINE_VERSION@cmUIMsg"/>
                    </uix:contents>
	          </uix:rowLayout>

                  <uix:labeledFieldLayout labelWidth="100">
                    <uix:contents>
                      <uix:messageLovInput id="rightBLName"
                           promptBinding="BASELINE_NFMT@cmUIMsg"
                           shortDescBinding="BASELINE_NFMT@cmUIMsg"
                           tipBinding="SAVED_BASELINE_VERSION_TIP@cmUIMsg"
                           name="rightBLName"
                           columns="44"
                           textBinding="rightBLName@compareBean@servletRequest"
                           searchDescBinding="CLICK_TO_SELECT_BASELINE@cmUIMsg"
                           destinationBinding="selectBLVersionDest@compareBean@servletRequest"
                           messageBinding="(BASELINE_NAME@cmUIMsg)@messages@servletRequest"
                           messageTypeBinding="(BASELINE_NAME@cmUIMsg)@messageTypes@servletRequest"/>
                      <!-- Capture Before Compare -->
                      <uix:messagePrompt prompt=""/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:checkBox name="rightCaptureFirst"
                               textBinding="CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg"
                               shortDescBinding="CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg"
                               disabledBinding="rightCaptureFirstDisabled@compareBean@servletRequest"
                               checkedBinding="rightCaptureFirst@compareBean@servletRequest"/>
                          <uix:messageText
                               messageBinding="(CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg)@messages@servletRequest"
                               messageTypeBinding="(CAPTURE_FIRST_BEFORE_COMPARE@cmUIMsg)@messageTypes@servletRequest"/>     
                        </uix:contents>
                      </uix:stackLayout>
	  	    </uix:contents>
		  </uix:labeledFieldLayout>

            <%@ include file="/database/changemgr/compare/compareWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
