<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       compareWizReview.jsp
 *
 *      NOTES
 *       jsp for CM compare UI - Review
 *       The key to the bean supporting the wizard
 *       is 'compareBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      06/16/05 - change ignore partition text 
 *    xshen      05/16/05 - ignore partition option 
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      04/27/05 - add ignore tbl col num 
 *    xshen      04/18/05 - pattern support 
 *    xshen      03/22/05 - add init param to review page 
 *    xshen      02/14/05 - remove cancel url from form 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      01/18/05 - support capture first before compare 
 *    xshen      10/01/04 - changing id 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/22/04 - do not render ignore name diff row if 
 *    xshen      09/21/04 - ui changes 
 *    xshen      09/15/04 - fix block size to 10 for wizard 
 *    xshen      09/13/04 - ui review changes 
 *    xshen      09/10/04 - ui review changes 
 *    xshen      08/13/04 - use msging jspf 
 *    xshen      08/12/04 - use summary ui name 
 *    xshen      06/25/04 - add schema map display string
 *    xshen      06/17/04 - xshen_changemgr_compareui
 *    xshen      06/15/04 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@compareBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="compareForm" 
               method="POST"
               destinationBinding="compareDestination@compareBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/compare/compareWizReview"/>

        <uix:pageLayout 
             titleBinding="titleString@compareBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@compareBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="LEFT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="RIGHT_SOURCE@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>
            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <%@ include file="/database/changemgr/compare/bipartitePS.jspf" %>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <!-- Review Comparison Options -->
            <uix:tableLayout width="80%">
              <uix:contents>
                <uix:labeledFieldLayout labelWidth="30%">
                  <uix:contents>
                    <!-- Comparison Name -->
                    <uix:messagePrompt
                         promptBinding="COMPARISON_NAME@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="newName@compareBean@servletRequest"/>

                    <!-- Left Source -->
                    <uix:messagePrompt
                         promptBinding="LEFT_SOURCE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="leftSummaryDisplay@compareBean@servletRequest"/>

                    <!-- Capture Left First -->
                    <uix:messagePrompt
                         promptBinding="CAPTURE_FIRST_LEFT@cmUIMsg"
                         renderedBinding="showReviewLeftCaptureFirst@compareBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="reviewLeftCaptureFirst@compareBean@servletRequest"
                         renderedBinding="showReviewLeftCaptureFirst@compareBean@servletRequest"/>

                    <!-- Right Source -->
                    <uix:messagePrompt
                         promptBinding="RIGHT_SOURCE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="rightSummaryDisplay@compareBean@servletRequest"/>

                    <!-- Capture Right First -->
                    <uix:messagePrompt
                         promptBinding="CAPTURE_FIRST_RIGHT@cmUIMsg"
                         renderedBinding="showReviewRightCaptureFirst@compareBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="reviewRightCaptureFirst@compareBean@servletRequest"
                         renderedBinding="showReviewRightCaptureFirst@compareBean@servletRequest"/>

                    <!-- Description -->
                    <uix:messagePrompt
                         promptBinding="DESCRIPTION@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="newDescription@compareBean@servletRequest"/>

                    <!-- Types: Only Shown if showReviewTypes is true -->
                    <uix:messagePrompt
                         promptBinding="OBJECTTYPES@dbUIMsg"
                         renderedBinding="showReviewTypes@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="selectedTypeString@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewTypes@specifyScopeBean@servletRequest"/>

                    <!-- Schemas: Only Shown if showReviewSchemas is true -->
                    <!-- when getObjectMode is false -->
                    <uix:messagePrompt
                         promptBinding="schemaPrompt@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewSchemas@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="selectedSchemaString@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewSchemas@specifyScopeBean@servletRequest"/>

                    <!-- Patterns: Only Shown if showPrefixPattern is true -->
                    <!-- when getObjectMode is false -->
                    <uix:messagePrompt
                         promptBinding="OBJNAME_STARTSWITH@cmUIMsg"
                         renderedBinding="showPrefixPattern@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="prefixInputString@specifyScopeBean@servletRequest"
                         renderedBinding="showPrefixPattern@specifyScopeBean@servletRequest"/>
      
                    <!-- Schema Map: Only show non-identity mappings -->
                    <uix:messagePrompt
			 renderedBinding="showSchemaMapString@compareBean@servletRequest"
                         promptBinding="SCHEMA_MAP@cmUIMsg"/>
                    <uix:styledText
			 renderedBinding="showSchemaMapString@compareBean@servletRequest"
                         styleClass="OraDataText"
                         textBinding="schemaMapString@compareBean@servletRequest"/>

                    <!-- Grants -->
                    <uix:messagePrompt
                         promptBinding="GRANTS_FOR_USERS_ROLES@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="grantString@compareBean@servletRequest"/>

                    <!-- Init Ora -->
                    <uix:messagePrompt
                         promptBinding="INITIALIZATION_PARAMETERS@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="initOraString@compareBean@servletRequest"/>

                    <!-- Comparison Options -->
                    <uix:messagePrompt
                         promptBinding="IGNORE_PHYSICAL@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignorePhysicalString@compareBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="IGNORE_TABLESPACE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignoreTbspString@compareBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="MATCH_CONSTRAINTS@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="matchConsString@compareBean@servletRequest"/>
                    <uix:messagePrompt 
                         renderedBinding="showReportNameDiff@compareBean@servletRequest"
                         promptBinding="REPORT_NAME_DIFF@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         renderedBinding="showReportNameDiff@compareBean@servletRequest"
                         textBinding="reportNameDiffString@compareBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="IGNORE_TBLCOL_NUM@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignoreTblColNumString@compareBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="IGNORE_HIGH_VALUES@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignorePartitionString@compareBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="LOGICAL_SQL_COMPARE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="logicalSQLString@compareBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="COMPARE_STATS@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="compareStatsString@compareBean@servletRequest"/>

                  </uix:contents>
                </uix:labeledFieldLayout>        
              </uix:contents>
            </uix:tableLayout>

            <!-- Object Table: Only Shown if showReviewObjects is true -->

            <uix:header textBinding="OBJECTS_TO_INCLUDE@cmUIMsg" 
                        renderedBinding="showReviewObjects@specifyScopeBean@servletRequest">
              <uix:table width="70%"
                         summaryBinding="OBJECTS_TO_INCLUDE@cmUIMsg"
                         partialRenderMode="self"
                         id="selectedItemsTable"
                         name="selectedItemsTable"
                         alternateTextBinding="alternateText@specifyScopeBean@servletRequest"
                         formSubmitted="true"
                         valueBinding="value@specifyScopeBean@servletRequest"
                         maxValueBinding="maxValue@specifyScopeBean@servletRequest"
                         blockSize="10"
                         tableDataBinding="selectedItems@specifyScopeBean@servletRequest"
                         columnHeaderDataBinding="columnHeaders@specifyScopeBean@servletRequest" 
                         columnFormatsBinding="columnFormats@specifyScopeBean@servletRequest">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader textBinding="text"
                                              valueBinding="value"
                                              sortableBinding="sort"/>
                        </uix:columnHeaderStamp>
                        <uix:contents>
                          <uix:styledText textBinding="sname"/>
                          <uix:styledText textBinding="oname"/>
                          <uix:styledText textBinding="otype"/>
                        </uix:contents>
              </uix:table>
            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelCompare"
                    textBinding="CANCEL@dbUIMsg"/>
                <uix:navigationBar
                    name="compareNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxStepValue@compareBean@servletRequest"
                    valueBinding="stepValue@compareBean@servletRequest"
                    formSubmitted="true"
                    formName="compareForm"
                    destinationBinding="compareDestination@compareBean@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="finishCompare"
                    shortDescBinding="SUBMIT@dbUIMsg"
                    textBinding="SUBMIT@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
