<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       diffViewer.jsp
 *
 *      NOTES
 *       A generic diff viewer - launched from cm object list 
 *       page for an action View (Differences) issued. 
 *       The bean underneath the view is 'diffViewerBean' 
 *        
 * MODIFIED 
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   09/16/08 - put back Return button
 *    mahessub   03/06/07 - support diff from synch object list
 *    xshen      02/15/07 - XbranchMerge xshen_cm_bugs from st_emdbsa_11.1
 *    xshen      01/03/07 - synch diff object
 *    xshen      06/25/05 - support bl object in-memory diffing 
 *    xshen      05/11/05 - support view comment/add one comment 
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      04/05/05 - adding bottom nav node 
 *    xshen      04/04/05 - adding navigation 
 *    xshen      04/04/05 - changing layout 
 *    xshen      03/31/05 - ui exit review changes 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      10/07/04 - tip render binding 
 *    xshen      10/02/04 - color code source line diff 
 *    xshen      10/02/04 - adding line diff 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/23/04 - support hide show 
 *    xshen      08/12/04 - use show ddl binding 
 *    xshen      07/15/04 - xshen_changemgr_addl_todiff-0715
 *    xshen      07/08/04 - Created
 *
--%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@diffViewerBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="diffViewerForm" 
	       method="POST"
               destinationBinding="diffViewerDest@diffViewerBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,guid,version,specGuid,specType,target,type,objectName,objectType,objectSchema,ctxType,previousVersion,diffMode,launchCtx">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/diffViewer"/>

        <uix:pageLayout 
             titleBinding="titleString@diffViewerBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

        <uix:labeledFieldLayout columns="2" width="80%">
          <uix:contents>
                <uix:messagePrompt promptBinding="LEFT_SOURCE@cmUIMsg"
                                   renderedBinding="comparisonType@diffViewerBean@servletRequest"/>
                <uix:messagePrompt promptBinding="SOURCE@cmUIMsg"
                                   renderedBinding="synchronizationType@diffViewerBean@servletRequest"/>                                   
                <uix:styledText styleClass="OraDataText"
                                textBinding="leftSourceDisplay@diffViewerBean@servletRequest"/>

                <uix:messagePrompt promptBinding="RIGHT_SOURCE@cmUIMsg"
                                   renderedBinding="comparisonType@diffViewerBean@servletRequest"/>
                <uix:messagePrompt promptBinding="DESTINATION@cmUIMsg"
                                   renderedBinding="synchronizationType@diffViewerBean@servletRequest"/>  
                <uix:styledText styleClass="OraDataText"
                                textBinding="rightSourceDisplay@diffViewerBean@servletRequest"/>         

                <uix:messagePrompt promptBinding="OBJECT_TYPE@dbUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="objectType@diffViewerBean@servletRequest"/>

                <uix:messagePrompt renderedBinding="showObjectSchema@diffViewerBean@servletRequest"
                                promptBinding="SCHEMA@dbUIMsg"/>
                <uix:styledText renderedBinding="showObjectSchema@diffViewerBean@servletRequest"
				styleClass="OraDataText"
                                textBinding="objectSchemaDisplayString@diffViewerBean@servletRequest"/>                                                       

                <uix:messagePrompt promptBinding="OBJECT_NAME@dbUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="objectName@diffViewerBean@servletRequest"/>                       

          </uix:contents>
        </uix:labeledFieldLayout>

        <!-- Difference Viewer Tree -->
        <uix:header textBinding="DIFFERENCES@cmUIMsg">
         <uix:stackLayout>
          <uix:hGrid id="diffTree" width="100%" 
               summaryBinding="DIFFERENCES@cmUIMsg"
               alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
               destinationBinding="diffViewerDest@diffViewerBean@servletRequest"
               columnFormatsBinding="columnFormats@diffViewerBean@servletRequest"
               columnHeaderDataBinding="columnHeaderData@diffViewerBean@servletRequest"
               treeDataBinding="diffTree@diffViewerBean@servletRequest"
               proxyBinding="diffViewerProxy@servletRequest"
               formSubmitted="true">
              <uix:tableFormat tableBanding="rowBanding"/>
               
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="ATTRIBUTES@cmUIMsg"/>
                  </uix:columnHeader>	      
                  <uix:styledText styleClass="OraFieldText" textBinding="text"/>
                </uix:column>
              </uix:nodeStamp>
            
              <uix:columnHeaderStamp>
                <uix:text textBinding="text"/>
              </uix:columnHeaderStamp>
            
              <uix:styledText textBinding="lvalue"/>
              <uix:styledText textBinding="rvalue"/>
              <%-- <uix:styledText textBinding="diffkind"/> --%>
            </uix:hGrid>
            <uix:tip renderedBinding="showLeftDDL@diffViewerBean@servletRequest">
              <uix:styledText renderedBinding="comparisonType@diffViewerBean@servletRequest" textBinding="VIEW_DDL_TIP@cmUIMsg"/>
              <uix:styledText renderedBinding="synchronizationType@diffViewerBean@servletRequest" textBinding="VIEW_DDL_SYNCH_TIP@cmUIMsg"/>
            </uix:tip>
           </uix:stackLayout>
	  </uix:header>

  	  <uix:tableLayout width="100%" cellSpacing="5"
               renderedBinding="showSourceDiffString@diffViewerBean@servletRequest">
           <uix:rowLayout>
            <uix:hideShowHeader id="srcDiff"
                                formSubmitted="true"
                                formName="diffViewerForm"
                                disclosedBinding="srcDiffDisclosed@diffViewerBean@servletRequest"
                                partialRenderMode="self"
                                unvalidated="true"
                                textBinding="srcDiffHeader@diffViewerBean@servletRequest">
             <uix:contents>
              <uix:stackLayout>
<%--
               <!-- 1.  The raw diff output as is -->
               <uix:textInput readOnly="true"
                              rows="10"
                              columns="120"
                              textBinding="sourceDiffString@diffViewerBean@servletRequest"/>
               <!-- 2.  Color coded line diffs -->
               <uix:stackLayout>
                 <uix:contents childDataBinding="sourceDiffLines@diffViewerBean@servletRequest">
                   <uix:styledText styleClassBinding="diffStyle"
                                   textBinding="oneDiffLine"/>
                 </uix:contents>
               </uix:stackLayout>
--%>
               <!-- 3.  A table -->
<%--
               <uix:table width="100%"
                          partialRenderMode="self"
                          id="sourceDiffTable"
                          name="sourceDiffTable"
                          alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg"
                          formSubmitted="true"
                          valueBinding="sourceDiffValue@diffViewerBean@servletRequest"
                          maxValueBinding="sourceDiffMaxValue@diffViewerBean@servletRequest"
                          blockSize="10"
                          tableDataBinding="sourceDiffTableData@diffViewerBean@servletRequest"
                          columnHeaderDataBinding="sourceDiffColumnHeaders@diffViewerBean@servletRequest"
                          columnFormatsBinding="sourceDiffColumnFormats@diffViewerBean@servletRequest">
                      <uix:tableFormat tableBanding="rowBanding"/>
                      <uix:columnHeaderStamp>
                        <uix:sortableHeader textBinding="text"
                                            sortableBinding="sort"/>
                      </uix:columnHeaderStamp>
                      <uix:contents>
                        <uix:styledText textBinding="leftpos" 
                                        styleClassBinding="leftstyle"/>
                        <uix:formattedText textBinding="lefttext" 
                                           styleClassBinding="leftstyle"/>
                        <uix:image shortDescBinding="changeshortdesc"
                                   sourceBinding="changeimg"/>
                        <uix:formattedText textBinding="righttext"
                                           styleClassBinding="rightstyle"/>
                        <uix:styledText textBinding="rightpos"
                                        styleClassBinding="rightstyle"/>
                      </uix:contents>
               </uix:table>
--%>
               <!-- 3.  A table, use ui node -->
               <%@ include file="/database/changemgr/sqlDiffNodeActions.jspf" %>

              </uix:stackLayout>
             </uix:contents>
            </uix:hideShowHeader>
           </uix:rowLayout>
          </uix:tableLayout>

          <!-- View Comment / Add One Comment Widget-->
          <!-- This should not be rendered when diffing 2 bl objects -->

<%@ page import="oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.DiffViewer" %>
<%@ page import="oracle.sysman.dbTarget.db.changemgr.controller.CMUIConstants" %>
<%  DiffViewer diffViewerBean = (DiffViewer)request.getAttribute(CMUIConstants.DIFFVIEWER_BEAN);
    if (diffViewerBean != null && diffViewerBean.getShowCommentUI())
    {
%>
  	  <uix:tableLayout width="100%" cellSpacing="5" >
           <uix:rowLayout>
            <uix:hideShowHeader id="viewComment"
                                formSubmitted="true"
			        formName="diffViewerForm"
                                disclosedBinding="commentDisclosed@diffViewerBean@servletRequest"
                                partialRenderMode="self"
                                unvalidated="true"
                                textBinding="VIEW_COMMENTS@cmUIMsg">
             <uix:contents>
               <%@ include file="/database/changemgr/addOneComment.jspf"%>
             </uix:contents>
            </uix:hideShowHeader>
           </uix:rowLayout>
          </uix:tableLayout>
<% } %>

          <uix:tableLayout width="100%" cellSpacing="5">
            <uix:rowLayout vAlign="top">
              <uix:cellFormat width="50%" hAlign="left"
                   renderedBinding="showLeftDDL@diffViewerBean@servletRequest">
                <uix:hideShowHeader id="leftDDL"
                              formSubmitted="true"
                              formName="diffViewerForm"
                              disclosedBinding="leftDisclosed@diffViewerBean@servletRequest"
                              partialRenderMode="self"
                              unvalidated="true"
                              textBinding="DDLHeader1@diffViewerBean@servletRequest">
                  <uix:contents>
                    <db:sqlDisplay sqlListBinding="leftDDL@diffViewerBean@servletRequest"/>
                  </uix:contents>
               </uix:hideShowHeader>
              </uix:cellFormat>
              <uix:cellFormat width="50%" hAlign="left"
                              renderedBinding="showRightDDL@diffViewerBean@servletRequest">
                <uix:hideShowHeader id="rightDDL"
                              formSubmitted="true"
                              formName="diffViewerForm"
                              disclosedBinding="rightDisclosed@diffViewerBean@servletRequest"
                              partialRenderMode="self"
                              unvalidated="true"
                              textBinding="DDLHeader2@diffViewerBean@servletRequest">
                  <uix:contents>
                    <db:sqlDisplay sqlListBinding="rightDDL@diffViewerBean@servletRequest"/>
                  </uix:contents>
               </uix:hideShowHeader>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <!-- Action Buttons -->
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="RETURN@dbUIMsg"
                          shortDescBinding="RETURN@dbUIMsg"
                          destinationBinding="cancelURL@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


