<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       edit.jsp
 *
 *      NOTES
 *       jsp launched from specList page for an action 
 *       Edit Schedule issued. The beans underneath is 
 *       cmCredsBean & scheduleBean.
 *       The controller for this page is SpecListController.
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      01/20/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      08/17/04 - use msging
 *    xshen      05/11/04 - xshen_changemgr-0510
 *    xshen      05/10/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="editForm" 
               method="POST"
               destination="/console/database/changemgr/specList"
               copyParams="cancelURL,cmCtxType,specType,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/edit"/>
      <uix:formValue name="mode" 
                     valueBinding="mode@servletRequest"/>

        <uix:pageLayout 
             titleBinding="EDIT_JOB_OPTIONS@cmUIMsg">
        <%@ include file="/oemGlobal.jspf" %>
        <!-- Messaging Area -->
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

          <!-- Instruction -->
            <uix:rowLayout>
              <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionText"
                     textBinding="editInstruction@servletRequest"/>
              </uix:flowLayout>
            </uix:rowLayout>

          <uix:spacer height="10"/>

            <!-- Summary -->
            <%@ include file="/database/changemgr/specSummary.jspf"%>

            <!-- Specify Credential: Use our own credential widget until 
              -- one available from sdk, both jspf and bean
              -->
            <%@ include file="/database/changemgr/cmCreds.jspf"%>

            <!-- Specify Schedule -->
            <uix:header textBinding="SCHEDULE@dbUIMsg">
              <%@ include file="/sdk/schedule/schedule.jspf"%>
            </uix:header>

            <!-- Cancel and Submit Buttons -->
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@dbUIMsg"
                            shortDescBinding="CANCEL@dbUIMsg"
                            destinationBinding="editNoDest@servletRequest"/>
                <uix:submitButton name="event" 
                                  shortDescBinding="SUBMIT@dbUIMsg"
                                  value="editOK"
                                  unvalidated="true"
                                  textBinding="SUBMIT@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
