<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       generateDDL.jsp
 *
 *      NOTES
 *       jsp launched from cm object list page for an action 
 *       Generate DDL issued. The bean underneath the view 
 *       is 'generateDDLBean' 
 *        
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      06/03/04 - support generate baseline ddl
 *    xshen      05/13/04 - xshen_changemgr_genddl_kuxsl
 *    xshen      05/12/04 - Created
 *
--%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@generateDDLBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="generateDDLForm" 
	       method="POST"
               destinationBinding="generateDDLDest@generateDDLBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,guid,version,specGuid,specType,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/generateDDL"/>

        <uix:pageLayout 
             titleBinding="titleString@generateDDLBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <uix:tableLayout 
             renderedBinding="baselineMode@generateDDLBean@servletRequest">
          <uix:contents>			      
	    <uix:rowLayout>
              <uix:contents>
                <uix:messagePrompt 
		     promptBinding="ONLY_SIZE_DDL_DISPLAYED@cmUIMsg"/>
              </uix:contents>
	    </uix:rowLayout>
          </uix:contents>
        </uix:tableLayout>

          <uix:stackLayout>
            <db:sqlDisplay 
                sqlListBinding="generatedSQLs@generateDDLBean@servletRequest"/>
          </uix:stackLayout>

          <!-- Action Buttons -->
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="OK@dbUIMsg"
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton 
		   renderedBinding="baselineMode@generateDDLBean@servletRequest"
		   textBinding="SAVE_TO_FILE@cmUIMsg"
		   shortDescBinding="SAVE_TO_FILE@cmUIMsg"
		   name="event"
		   value="saveToFile"/>
              <uix:submitButton 
		   renderedBinding="baselineMode@generateDDLBean@servletRequest"
		   textBinding="DROP_DDL@cmUIMsg"
		   shortDescBinding="DROP_DDL@cmUIMsg"
                   name="event"
		   value="dropVersionDDL"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


