<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       initOra.jsp
 *
 *      NOTES
 *       jsp for a list of initialization parameters 
 *       in a baseline / comparison.
 *       The bean key of the supporting model
 *       is 'cmObjListBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   09/15/08 - put back Return button
 *    xshen      02/15/07 - XbranchMerge xshen_cm_bugs from st_emdbsa_11.1
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      03/31/05 - change to table action 
 *    xshen      03/27/05 - xshen_changemgr_initora-0324
 *    xshen      03/25/05 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="initOraBrowserTitle@cmObjListBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="cmObjListForm" 
               method="POST"
               destinationBinding="cmObjListDestination@cmObjListBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,specGuid,specType,target,type,ctxType">
      <uix:formValue name="guid" valueBinding="guid@cmObjListBean@servletRequest"/>
      <uix:formValue name="version" 
                     valueBinding="version@cmObjListBean@servletRequest"/>
      <uix:formValue name="pageName" 
                     value="/database/changemgr/initOra"/>

        <uix:pageLayout 
             titleBinding="initOraTitleString@cmObjListBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   
  
          <oem:table name="initOraTable"
                     summaryBinding="initOraTitleString@cmObjListBean@servletRequest"
                     id="initOraTable"
                     destinationBinding="cmObjListDestination@cmObjListBean@servletRequest"
                     width="80%"
                     blockSize="25"
                     beanKey="cmObjListBean"
                     formSubmitted="true"
                     dataSourceProp="initOraTable"
                     alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg">
  	      <!-- Show Filter : only for comparison -->
              <uix:tableActions>
                <uix:rowLayout renderedBinding="comparisonType@cmObjListBean@servletRequest">
                  <uix:messageChoice 
                       name="showInitOraOption" 
                       id="showInitOraOption"
                       promptBinding="SHOW@cmUIMsg"
                       renderedBinding="comparisonType@cmObjListBean@servletRequest" 
  	               primaryClientActionBinding="showInitOraOptionClientAction@servletRequest"
                       selectedValueBinding="showInitOraOption@cmObjListBean@servletRequest">
                    <uix:contents 
                         childDataBinding="showInitOraOptions@cmObjListBean@servletRequest">
                      <uix:option textBinding="text" valueBinding="value"/>
                    </uix:contents>
                  </uix:messageChoice>
       	        </uix:rowLayout>
              </uix:tableActions>
            </oem:table>

         <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="RETURN@dbUIMsg"
                        shortDescBinding="RETURN@dbUIMsg"
                        destinationBinding="cancelURL@servletRequest"/>
          </uix:pageButtonBar>
         </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
