<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       prntblReport.jsp
 *
 *      NOTES
 *       jsp for a printable report of an existing bl / comp
 *       The bean keys of the supporting model
 *       is 'listCommBean' and 'cmObjListBean'.
 *       Note: we make this page separate from launching page
 *       because, there is no event on the page, it will not 
 *       be obvious the original bean is operated in a printable 
 *       mode or not (when a user use back button) - a reason 
 *       we do not use a bean mode and switch UI on the orig page.
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   10/24/07 - 
 *    xshen      05/13/05 - ada
 *    xshen      01/19/05 - adding browser title 
 *    xshen      11/11/04 - block size 
 *    xshen      11/08/04 - hint not shown always 
 *    xshen      10/11/04 - xshen_changemgr_reports-1010
 *    xshen      10/10/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@cmObjListBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
        <uix:pageLayout 
             titleBinding="titleString@cmObjListBean@servletRequest">
        <%-- @ include file="/oemGlobal.jspf" --%>
        <!-- Messaging Area -->
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   
          <uix:contents>  

<!-- The following in sync with listCommon -->
<!-- Begin Common General Section          -->
<uix:tableLayout width="80%">
  <uix:rowLayout vAlign="top">
    <!-- Left label value pairs -->
    <uix:labeledFieldLayout>
      <uix:contents>

	<!-- Source Database: only rendered for baseline mode -->
        <uix:messagePrompt 
             renderedBinding="baselineType@listCommBean@servletRequest"
             promptBinding="SOURCE_DATABASE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="baselineType@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="source@listCommBean@servletRequest"/>

        <!-- Right source name / type -->
        <uix:messagePrompt 
             renderedBinding="comparisonType@listCommBean@servletRequest"
             promptBinding="LEFT_SOURCE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="comparisonType@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="leftSourceDisplay@listCommBean@servletRequest"/>
        <uix:messagePrompt 
             renderedBinding="comparisonType@listCommBean@servletRequest"
             promptBinding="LEFT_TYPE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="showLeftTypeDatabase@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="DATABASE_TYPE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="showLeftTypeBaseline@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="BASELINE_NFMT@cmUIMsg"/>

        <uix:messagePrompt
             promptBinding="OWNER@cmUIMsg"/>
        <uix:styledText
             styleClass="OraDataText"
             textBinding="owner@listCommBean@servletRequest"/>

        <uix:messagePrompt 
             renderedBinding="baselineType@listCommBean@servletRequest"
             promptBinding="CREATION_DATE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="baselineType@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="creationDate@listCommBean@servletRequest"/>

      </uix:contents>
    </uix:labeledFieldLayout>

    <!-- Right label value pairs -->
    <uix:labeledFieldLayout>
      <uix:contents>

        <!-- Right source name / type -->
        <uix:messagePrompt 
             renderedBinding="comparisonType@listCommBean@servletRequest"
             promptBinding="RIGHT_SOURCE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="comparisonType@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="rightSourceDisplay@listCommBean@servletRequest"/>
        <uix:messagePrompt 
             renderedBinding="comparisonType@listCommBean@servletRequest"
             promptBinding="RIGHT_TYPE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="showRightTypeDatabase@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="DATABASE_TYPE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="showRightTypeBaseline@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="BASELINE_NFMT@cmUIMsg"/>

        <uix:messagePrompt
             renderedBinding="comparisonType@listCommBean@servletRequest"
             promptBinding="CREATION_DATE@cmUIMsg"/>
        <uix:styledText
             renderedBinding="comparisonType@listCommBean@servletRequest"
             styleClass="OraDataText"
             textBinding="creationDate@listCommBean@servletRequest"/>

      </uix:contents>
    </uix:labeledFieldLayout>
  </uix:rowLayout>
</uix:tableLayout>

            <!-- The followings in sync with cmObjList -->  
            <uix:header textBinding="RESULTS@dbUIMsg">
              <uix:rowLayout width="80%" 
			     renderedBinding="exceedMaxPrntblCount@cmObjListBean@servletRequest">
                <uix:messagePrompt 
                     promptBinding="prntblMaxSizeString@cmObjListBean@servletRequest"/>
	      </uix:rowLayout>
              <oem:table name="prntblObjListTable"
                         summaryBinding="RESULTS@dbUIMsg"
                         width="80%"
                         blockSizeBinding="prntblBS@cmObjListBean@servletRequest"
                         beanKey="cmObjListBean"
                         formSubmitted="true"
                         dataSourceProp="prntblObjListTable"
                         alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg"/>
            </uix:header>

          </uix:contents>    
        </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
