<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       repeatNow.jsp
 *
 *      NOTES
 *       jsp launched from specList page for an action 
 *       Repeat Now issued. 
 *       This page has a confirmation message and includes 
 *       cmCreds.jspf.  Else are request attributes.  If
 *       request attributes grow we may need to have a bean
 *       to store them.  The controller for this page is
 *       SpecListController.
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      01/20/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      08/17/04 - use msging
 *    xshen      08/03/04 - xshen_changemgr_repeat-0802
 *    xshen      08/02/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="repeatNowForm" 
               method="POST"
               destination="/console/database/changemgr/specList"
               copyParams="cancelURL,cmCtxType,specType,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/repeatNow"/>

        <uix:pageLayout 
             titleBinding="REPEAT_NOW@cmUIMsg">
        <%@ include file="/oemGlobal.jspf" %>
        <!-- Messaging Area -->
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <uix:header iconBinding="confirmationIcon@servletRequest" 
                        textBinding="CONFIRMATION@cmUIMsg">      
                <!-- Repeat Instruction -->
                <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:stackLayout>
                      <uix:flowLayout>
                        <uix:messagePrompt 
                             promptBinding="CONFIRM_INSTRUCTION@cmUIMsg"/>
                        <uix:spacer width="8"/>
                        <uix:messagePrompt 
			     promptBinding="CONFIRM_REPEAT@cmUIMsg"/>
                      </uix:flowLayout>
                      <uix:tip>
                        <uix:styledText textBinding="USE_EDIT_COMPARE@cmUIMsg" /> 
                      </uix:tip>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:tableLayout>
                <uix:spacer height="5"/>
                <!-- Summary -->
                <%@ include file="/database/changemgr/specSummary.jspf"%>
            </uix:header> 

            <!-- Specify Credential: Use our own credential widget until 
              -- one available from sdk, both jspf and bean
              -->
            <%@ include file="/database/changemgr/cmCreds.jspf"%>

            <!-- Yes and No Buttons -->
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@dbUIMsg"
                            shortDescBinding="CANCEL@dbUIMsg"
                            destinationBinding="repeatNoDest@servletRequest"/>
                <uix:submitButton name="event" 
                                  value="switchToEdit"
                                  textBinding="EDIT_JOB_OPTIONS@cmUIMsg"
                                  shortDescBinding="EDIT_JOB_OPTIONS@cmUIMsg"
                                  unvalidated="true"/>
                <uix:submitButton name="event" 
                                  value="repeatOK"
                                  textBinding="SUBMIT@dbUIMsg"
                                  shortDescBinding="SUBMIT@dbUIMsg"
                                  unvalidated="true"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
