<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       selectBLVersion.jsp
 *
 *      NOTES
 *       Select from a list of available baseline versions
 *       for which the user has access to.
 *       The bean key is 'selectBLVersionBean'
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      05/05/05 - ada coding standards 
 *    xshen      01/18/05 - fix bug 4125515 
 *    xshen      09/28/04 - improve ui 
 *    xshen      09/14/04 - make readonly drop-list a styled text 
 *    xshen      08/25/04 - add sortable header binding 
 *    xshen      08/24/04 - xshen_changemgr_lov_2-0824
 *    xshen      08/23/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_BASELINE@cmUIMsg"/>
    </uix:metaContainer>

    <uix:body>
      <uix:pageLayout>
       <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        --%>
          <uix:listOfValues titleBinding="BASELINE_NFMT@cmUIMsg"
                            shortDescBinding="BASELINE_NFMT@cmUIMsg"
			    styleClass="OraPromptText"
                            searchTextBinding="searchFieldValue@selectBLVersionBean@servletRequest">
            <uix:formValue name="pageName" value="/database/changemgr/selectBLVersion"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="TO_FIND_ITEM@dbUIMsg"/>
            </uix:searchInstructions>
            <uix:contents>
              <uix:table name="selectBLVersionTable"
                         summaryBinding="RESULTS@cmUIMsg"
                         alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg"
			 tableDataBinding="selectBLVersionTable@selectBLVersionBean@servletRequest"
                         columnHeaderDataBinding="columnHeaders@selectBLVersionBean@servletRequest"
                         columnFormatsBinding="columnFormats@selectBLVersionBean@servletRequest"
                         valueBinding="value@selectBLVersionBean@servletRequest" 
                         maxValueBinding="maxValue@selectBLVersionBean@servletRequest"
                         width="100%"
                         blockSize="10"
                         formSubmitted="true"
                         proxied="true">
                   <uix:tableFormat tableBanding="rowBanding"/>
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" sortableBinding="sort"/>
                   </uix:columnHeaderStamp>

                   <uix:contents>
	             <%-- Baseline Name --%>
                     <uix:styledText textBinding="blname"/>
                     <%-- Baseline version --%>
                     <uix:switcher childNameBinding="readonly">
                      <uix:case name="false">
                        <uix:choice name="selversion"
                                    selectedValueBinding="selversion"
                                    shortDescBinding="VERSIONS@cmUIMsg">
                         <uix:contents childDataBinding="blversions">
                          <uix:option textBinding="vtext" valueBinding="vvalue"/>
                         </uix:contents>
                        </uix:choice>
		      </uix:case>
                      <uix:case name="true">
                        <uix:stackLayout>
                          <uix:styledText textBinding="vtext"/>
			  <uix:formValue name="selversion" valueBinding="vtext"/>
                        </uix:stackLayout>
                      </uix:case>
                     </uix:switcher>
		     <%-- Source DB Name --%>
                     <uix:styledText textBinding="blsource"/>
	             <%-- Description --%>
                     <uix:styledText textBinding="bldesc"/>
	             <%-- Owner --%>
                     <uix:styledText textBinding="blowner"/>
                     <uix:formValue name="blname" valueBinding="blname"/>
                     <uix:formValue name="blowner" valueBinding="blowner"/>
                   </uix:contents>
                   <uix:tableSelection>
                    <uix:singleSelection shortDescBinding="SELECT@dbUIMsg" selectedIndex="0"/>
                   </uix:tableSelection>
              </uix:table>
          </uix:contents>
        </uix:listOfValues>
      </uix:contents>
     </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

