<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       specDef.jsp
 *
 *      NOTES
 *       Common jsp for a scope spec definition UI for 
 *       change manager. The key to the bean supporting 
 *       this view is 'specDefBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   02/20/07 - touching file to refresh changed static includes
 *    xshen      01/02/07 - adding information message for action required most
 *                          recent synch version
 *    mahessub   09/15/06 - touching file to refresh changed static includes
 *    xshen      06/25/05 - add changes since previous version button 
 *    xshen      05/09/05 - add show ignored results choice list 
 *    xshen      05/05/05 - ada coding standards 
 *    mpawelko   04/25/05 - bug 3269618: use VIEW_BUTTON for submitButton 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/21/04 - changing table width to 100% 
 *    xshen      08/13/04 - 
 *    xshen      06/16/04 - support comparison UI
 *    xshen      05/26/04 - support generate baseline DDL
 *    xshen      05/24/04 - message box - running job msg
 *    xshen      05/19/04 - factor out shared elements
 *    xshen      05/08/04 - further enhancements
 *    xshen      05/07/04 - ui changes
 *    xshen      04/12/04 - add copyparams
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/29/04 - Add copy param to version table
 *    xshen      03/14/04 - modified
 *    xshen      03/12/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@specDefBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="specDefForm" 
               method="POST"
               destinationBinding="specDefDestination@specDefBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,guid,specGuid,specType,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/specDef"/>

        <uix:pageLayout 
             titleBinding="titleString@specDefBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <!-- Messaging Area -->
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

        <!-- Action Required: Synch most recent version information area -->
            <uix:header renderedBinding="showActionRequiredInfo@specDefBean@servletRequest"
	                iconBinding="actionRequiredIcon@specDefBean@servletRequest" 
                        textBinding="ACTION_REQUIRED@cmUIMsg">
              <uix:tableLayout width="100%">
                <uix:rowLayout width="100%" vAlign="bottom">
                  <uix:styledText styleClass="OraInstructionText" 
                       textBinding="actionRequiredStatusInformation@specDefBean@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout><uix:spacer height="10"/></uix:rowLayout>
              </uix:tableLayout>

            <uix:separator/>

            </uix:header>

           <uix:contents>  

            <!-- Page Level Action List -->
	 
            <!-- Include common section -->
            <%@ include file="/database/changemgr/specDefComm.jspf" %>

            <!-- Show Versions Section -->
            <uix:header textBinding="VERSIONS@cmUIMsg">              
              <oem:table name="versionsTable"
                         id="versionsTable"
                         summaryBinding="VERSIONS@cmUIMsg"
                         width="100%"
                         blockSize="25"
                         beanKey="specDefBean"
                         formSubmitted="true"
                         dataSourceProp="versionsTable"
                         alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg">
                <!-- Show: Results | Including Ignored Results -->
                <uix:tableActions>
                 <uix:rowLayout 
                      renderedBinding="comparisonType@specDefBean@servletRequest">
                  <uix:messageChoice name="showIgnoredOption" 
                       primaryClientActionBinding="showIgnoredOptionClientAction@servletRequest"
                       id="showIgnoredOption"
                       promptBinding="SHOW@cmUIMsg"
                       selectedValueBinding="showIgnoredOption@specDefBean@servletRequest">
                    <uix:contents>
                     <uix:option textBinding="RESULTS@cmUIMsg" 
                                 value="RESULTS"/>
                     <uix:option textBinding="INCLUDING_IGNORED@cmUIMsg" 
                                 value="INCLUDING_IGNORED"/>
                    </uix:contents>
                   </uix:messageChoice>
                  </uix:rowLayout>
                 </uix:tableActions>

                <uix:tableSelection>
                  <uix:singleSelection 
                         shortDescBinding="SELECT@dbUIMsg"
                         selectedIndexBinding="selectedIndex@specDefBean@servletRequest">
                    <!-- View and Delete Buttons -->
                    <uix:submitButton
                         name="event"
                         value="viewVersion"
                         shortDescBinding="VIEW_BUTTON@dbUIMsg"
                         textBinding="VIEW_BUTTON@dbUIMsg"/>
                    <uix:submitButton
                         renderedBinding="baselineType@specDefBean@servletRequest"
	                 disabledBinding="viewVersionChangesDisabled@specDefBean@servletRequest"
                         name="event"
                         value="viewVersionChanges"
                         shortDescBinding="VIEW_CHANGES_SINCE@cmUIMsg"
                         textBinding="VIEW_CHANGES_SINCE@cmUIMsg"/>
                    <uix:submitButton 
                         renderedBinding="baselineType@specDefBean@servletRequest"
                         name="event"
                         value="generateVersionDDL"
                         shortDescBinding="GENERATE_DDL@cmUIMsg"
                         textBinding="GENERATE_DDL@cmUIMsg"/>
                    <uix:submitButton
                         name="event"
                         value="deleteVersion"
                         shortDescBinding="DELETE@dbUIMsg"
                         textBinding="DELETE@dbUIMsg"/>
                  </uix:singleSelection>
                </uix:tableSelection>                         
              </oem:table>
            </uix:header>

          </uix:contents>    
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
