<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       specList.jsp
 *
 *      NOTES
 *       Common jsp for a scope spec object list UI for 
 *       change manager. For example, the  top-level
 *       baselines and comparisons pages.  The bean key 
 *       supporting this view is 'specListBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    xshen      02/15/07 - XbranchMerge xshen_cm_bugs from st_emdbsa_11.1
 *    mahessub   01/30/07 - 
 *    xshen      12/04/06 - oac
 *    mahessub   08/08/06 - added synch spec list
 *    xshen      03/14/06 - bug 5090192 
 *    xshen      05/13/05 - ada testing 
 *    xshen      05/05/05 - ada coding standards 
 *    mpawelko   04/25/05 - bug 3269618: use VIEW_BUTTON for submitButton 
 *    xshen      01/19/05 - adding browser title 
 *    xshen      09/27/04 - adding ctx type 
 *    xshen      09/17/04 - ui review changes 
 *    xshen      09/13/04 - ui review changes 
 *    xshen      09/10/04 - ui review changes 
 *    xshen      08/13/04 - use common include for message
 *    xshen      06/14/04 - support comparisons
 *    xshen      04/22/04 - add messaging area
 *    xshen      04/06/04 - xshen_changemgr_clnt_base 
 *    xshen      04/05/04 - dir renaming
 *    xshen      03/24/04 - Add table copy param initial URL
 *    xshen      03/01/04 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>
<uix:bundle name="mntrResourceBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@specListBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="specListForm"
               method="POST"
               destinationBinding="specListDestination@specListBean@servletRequest"
               copyParams="cancelURL,cmCtxType,specType,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/specList"/>
      <uix:formValue name="event" value="searchSpec"/>

        <uix:pageLayout 
             titleBinding="titleString@specListBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <!-- Messaging Area -->
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

          <uix:contents>  

            <!-- Instruction Text -->
            <uix:rowLayout width="100%">
              <uix:cellFormat>
	            <uix:messagePrompt promptBinding="instructionText@specListBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="2"/>
            </uix:rowLayout>

            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%">
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" 
			          vAlign="top">
                   <uix:contents>
                    <uix:tableLayout>
                     <uix:rowLayout>
                       <uix:messageChoice 
                            shortDescBinding="SEARCH@dbUIMsg"
                            name="searchType" 
                            promptBinding="SEARCH@dbUIMsg"
                            selectedValueBinding="searchType@specListBean@servletRequest">
                         <uix:contents childDataBinding="searchTypes@specListBean@servletRequest">
                         <uix:option textBinding="text"
                                     valueBinding="value"/>
                         </uix:contents>
                       </uix:messageChoice>
                       <uix:spacer width="4"/>
                       <uix:textInput 
                            id="searchValue"
                            name="searchValue"
                            textBinding="searchValue@specListBean@servletRequest"
                            shortDescBinding="ENTER_OBJECT_NAME@dbUIMsg"/>
                       <uix:spacer width="4"/>
                       <uix:submitButton name="event" 
                                         value="searchSpec"
                                         shortDescBinding="GO@dbUIMsg"
                                         textBinding="GO@dbUIMsg"/>
                    </uix:rowLayout>
                   </uix:tableLayout>
                  </uix:contents>
                 </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>
            </uix:tableLayout>

<uix:separator/>

            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%" hAlign="right">
                 <!-- Create Button -->
                  <uix:submitButton name="event" 
                                    shortDescBinding="CREATE@dbUIMsg"
                                    value="createSpec"
                                    textBinding="CREATE@dbUIMsg"/>
              </uix:rowLayout>
            </uix:tableLayout>

            <!-- Object List Results Table -->
              
                <!-- Results Table -->
                <!-- Notes: do not copy target, type since this messup 
                  --   the target home page URL (each row might be for 
                  --   different target where as hidden param is global)
                  --   The same reason for specType when it comes to 
                  --   comparisons - a baseline link should not copy type
                  -->
                <oem:table name="specListTable"
                           id="specListTable"
                           summaryBinding="RESULTS@cmUIMsg"
                           copyParams="cancelURL,cmCtxType"
                           destinationBinding="specListDestination@specListBean@servletRequest"
                           width="100%"
                           blockSize="25"
                           beanKey="specListBean"
                           formSubmitted="true"
                           dataSourceProp="specListTable"
                           alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg">
                  <uix:tableSelection>
                    <uix:singleSelection 
                           shortDescBinding="SELECT@dbUIMsg"
                           selectedIndexBinding="selectedIndex@specListBean@servletRequest">

                      <!-- View  -->
                      <uix:submitButton
                           name="event"
                           value="viewSpec"
                           shortDescBinding="VIEW_BUTTON@dbUIMsg"
                           textBinding="VIEW_BUTTON@dbUIMsg"/>
                      <uix:spacer width="2"/>

                      <!-- Recapture Now: Baseline only -->
                      <uix:submitButton
                           renderedBinding="isBaseline@specListBean@servletRequest"
                           name="event"
                           value="RECAPTURE_NOW"
                           shortDescBinding="RECAPTURE_NOW@cmUIMsg"
                           textBinding="RECAPTURE_NOW@cmUIMsg"/>
                      <!-- Repeat Now: Comparison only -->
                      <uix:submitButton
                           renderedBinding="isComparison@specListBean@servletRequest"
                           name="event"
                           value="REPEAT_NOW"
                           shortDescBinding="REPEAT_NOW@cmUIMsg"
                           textBinding="REPEAT_NOW@cmUIMsg"/>
                      <uix:spacer width="2"/>
                      <!-- Synchronize Again: Synchronization only -->
                      <uix:submitButton
                           renderedBinding="isSynchronization@specListBean@servletRequest"
                           name="event"
                           value="SYNCHRONIZE_AGAIN"
                           shortDescBinding="SYNCHRONIZE_AGAIN@cmUIMsg"
                           textBinding="SYNCHRONIZE_AGAIN@cmUIMsg"/>
                      <uix:spacer width="2"/>
                      
                      <!-- Edit Job Options -->
                      <uix:submitButton
                           renderedBinding="showEditJobOptions@specListBean@servletRequest"
                           name="event"
                           value="EDIT_JOB_OPTIONS"
                           shortDescBinding="EDIT_JOB_OPTIONS@cmUIMsg"
                           textBinding="EDIT_JOB_OPTIONS@cmUIMsg"/>
                      <uix:spacer width="2"/>

                      <!-- Synchronize -->
                      <uix:submitButton
                           renderedBinding="isComparison@specListBean@servletRequest"
                           name="event"
                           value="SYNCHRONIZE"
                           shortDescBinding="SYNCHRONIZE@cmUIMsg"
                           textBinding="SYNCHRONIZE@cmUIMsg"/>
                      <uix:spacer width="2"/>
                      
                      <!-- Create Like -->
                      <uix:submitButton
                           name="event"
                           value="CREATE_LIKE"
                           shortDescBinding="CREATE_LIKE@dbUIMsg"
                           textBinding="CREATE_LIKE@dbUIMsg"/>
                      <uix:spacer width="2"/>

                      <!-- Delete -->
                      <uix:submitButton
                           name="event"
                           value="deleteSpec"
                           shortDescBinding="DELETE@dbUIMsg"
                           textBinding="DELETE@dbUIMsg"/>

                      <!-- Action List: Cut to use button list, if list grows to > 3, use drop-list. -->
                      <%-- uix:messageChoice name="specAction" 
                                         id="specAction"
                                         promptBinding="ACTIONS@dbUIMsg"
                                         selectedValueBinding="specAction@specListBean@servletRequest">
                        <uix:contents childDataBinding="specActions@specListBean@servletRequest">
                          <uix:option textBinding="text"
                                      valueBinding="value"/>
                        </uix:contents>
                      </uix:messageChoice>
                      <uix:submitButton name="event"
                                        value="ongoSpecAction"
                                        textBinding="GO@dbUIMsg"/ --%>

                    </uix:singleSelection>
                  </uix:tableSelection>                         
                </oem:table>
            
             <!-- Related Links: show peer link -->
             <uix:header textBinding="RELATED_LINKS@mntrResourceBundle">
               <uix:tableLayout width="66%"> 
                 <uix:rowLayout>
                   <uix:cellFormat>
                     <uix:link textBinding="relatedLink1Text@specListBean@servletRequest"
                               destinationBinding="relatedLink1Dest@specListBean@servletRequest"/>
                   </uix:cellFormat>
                   <uix:cellFormat>
                     <uix:link textBinding="relatedLink2Text@specListBean@servletRequest"
                               destinationBinding="relatedLink2Dest@specListBean@servletRequest"/>
                   </uix:cellFormat>
                 
                 </uix:rowLayout>                        
               </uix:tableLayout>               
             </uix:header>

          </uix:contents>    
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
