<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchAgainMode.jsp
 *
 *      NOTES
 *       jsp launched from specList page for an action 
 *       Synch Again issued. The bean underneath is
 *       synchBean.
 *       The controller for this page is SynchController.
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   05/13/08 - Merge 11GC functionality.
 *    mahessub   12/28/06 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>
<uix:bundle name="credsMsgBundle"
            class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="synchAgainForm" 
               method="POST"
               destinationBinding="synchDestination@synchBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/synch/synchAgainMode"/>
      <uix:formValue name="type" 
                     value="oracle_database"/>
      <uix:formValue name="cancelURL" 
                     valueBinding="dbLoginCancelURL@servletRequest"/>

        <uix:pageLayout 
             titleBinding="titleString@synchBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <%@ include file="/database/changemgr/synch/synchAgainBipartite.jspf" %>

            <%-- Synch mode and host credentials --%>
            <%@ include file="/database/changemgr/synch/mode.jspf" %>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    shortDescBinding="CANCEL@dbUIMsg"
                    name="event"
                    value="cancelSynchronize"
                    textBinding="CANCEL@dbUIMsg"/>
                <uix:spacer width="2"/>
                <uix:submitButton
                    shortDescBinding="CONTINUE@dbUIMsg"
                    name="event"
                    value="continueSynchronizeAgain"
                    textBinding="CONTINUE@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
            
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
