<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchContinueGeneration.jsp
 *
 *      NOTES
 *       jsp for a list of objects of comparison phase results,
 *       shown when continuing to script generation.
 *       The bean key of the supporting model
 *       is 'synchObjListBean'
 *       
 *
 * MODIFIED
 *    mahessub      01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub      05/13/08 - Merge 11GC functionality.
 *    mahessub      07/27/07 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchObjListBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="synchObjListForm" 
               method="POST"
               destinationBinding="synchObjListDestination@synchObjListBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,specGuid,specType,target,type,ctxType">
      <uix:formValue name="guid" valueBinding="guid@synchObjListBean@servletRequest"/>
      <uix:formValue name="version" valueBinding="version@synchObjListBean@servletRequest"/>
      <uix:formValue name="pageName" value="/database/changemgr/synch/synchContinueGeneration"/>

        <uix:pageLayout titleBinding="titleString@synchObjListBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="/database/changemgr/cmMsging.jspf" %>   
          <%@ include file="/database/changemgr/synch/synchVersionCommIncl.jspf" %>
          <%@ include file="/database/changemgr/synch/synchObjectListComm.jspf" %>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton
                  shortDescBinding="CANCEL@dbUIMsg"
                  name="event"
                  value="cancel"
                  textBinding="CANCEL@dbUIMsg"/>                   
              <uix:submitButton
                  shortDescBinding="CONTINUE@dbUIMsg"
                  name="event"
                  value="continueContinueGeneration"
                  textBinding="CONTINUE@dbUIMsg"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>