<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchContinueRegenerationScript.jsp
 *
 *      NOTES
 *       jsp for synch script shown when continuing to script execution.
 *       The bean keys of the supporting model
 *       are 'synchScriptBean' and 'listCommBean'
 *       
 *
 * MODIFIED
 *    mahessub      01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub      09/16/08 - Added acionCtx to form value to support regen
 *    mahessub      07/29/08 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchScriptBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="synchScriptForm" 
               method="POST"
               destinationBinding="destination@synchScriptBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,specGuid,specType,target,type,ctxType">
      <uix:formValue name="guid" valueBinding="guid@synchScriptBean@servletRequest"/>
      <uix:formValue name="version" valueBinding="version@synchScriptBean@servletRequest"/>
      <uix:formValue name="pageName" value="/database/changemgr/synch/synchContinueRegenerationScript"/>
      <uix:formValue name="actionCtx" valueBinding="actionContext@synchScriptBean@servletRequest"/>
      
        <uix:pageLayout 
             titleBinding="titleString@synchScriptBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="/database/changemgr/cmMsging.jspf" %>   
          <%@ include file="/database/changemgr/synch/synchVersionCommIncl.jspf" %>
          <uix:subTabLayout>
			<%@ include file="/database/changemgr/synch/synchVersionSubTabs.jspf" %>
			<%@ include file="/database/changemgr/synch/synchScriptComm.jspf" %>
          </uix:subTabLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
               <uix:button
                  shortDescBinding="CANCEL@dbUIMsg"
                  destinationBinding="cancelURL@servletRequest"
                  textBinding="CANCEL@dbUIMsg"/>
              <uix:submitButton
                  shortDescBinding="CONTINUE@dbUIMsg"
                  name="event"
                  value="continueContinueRegeneration"
                  textBinding="CONTINUE@dbUIMsg"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

         </uix:pageLayout>
       </db:form>         
     </uix:body>
   </uix:document>
 </uix:renderingContext>
