<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchScript.jsp
 *
 *      NOTES
 *       jsp for cm synchronization script line details
 *       The bean key of the supporting model
 *       is 'synchScriptLineBean'
 *       
 *
 * MODIFIED
 *    mahessub      01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub      05/13/08 - Merge 11GC functionality.
 *    mahessub      11/16/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchScriptLineBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
        <uix:pageLayout 
             titleBinding="titleString@synchScriptLineBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="/database/changemgr/cmMsging.jspf" %>
            <uix:tableLayout cellSpacing="5">
                <!-- script line type -->
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100">
			        <uix:messagePrompt 
			             promptBinding="SCRIPT_LINE_TYPE@cmUIMsg"/>
                   </uix:cellFormat>
			        <uix:styledText
			             styleClass="OraDataText"
			             textBinding="scriptLineType@synchScriptLineBean@servletRequest"/>
                </uix:rowLayout>
                
                <!-- object type -->
                <uix:rowLayout> 
                 <uix:cellFormat hAlign="right">
			        <uix:messagePrompt 
			             promptBinding="OBJECT_TYPE@cmUIMsg"/>
                   </uix:cellFormat>
			        <uix:styledText
			             styleClass="OraDataText"
			             textBinding="objectType@synchScriptLineBean@servletRequest"/>
                </uix:rowLayout>
                
                <!--  schema -->	
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
			        <uix:messagePrompt
			             promptBinding="SCHEMA@cmUIMsg"/>
                   </uix:cellFormat>
			        <uix:styledText
			             styleClass="OraDataText"
			             textBinding="schema@synchScriptLineBean@servletRequest"/>
                </uix:rowLayout>
                			             
			   <!--  object name -->
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
			        <uix:messagePrompt
			             promptBinding="OBJECT_NAME@cmUIMsg"/>
                   </uix:cellFormat>
			        <uix:styledText
			             styleClass="OraDataText"
			             textBinding="objectName@synchScriptLineBean@servletRequest"/>
                </uix:rowLayout>
                			             
			   <!--  script line -->
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top">
			        <uix:messagePrompt
			             promptBinding="SCRIPT_LINE@cmUIMsg" vAlign="top"/>
                   </uix:cellFormat>
			        <uix:textInput
                            shortDescBinding="SCRIPT_LINE@cmUIMsg"
                            columns="120" rows="16" wrap="soft" readOnly="true"
                            textBinding="scriptLine@synchScriptLineBean@servletRequest"/>
                </uix:rowLayout>			       
          </uix:tableLayout>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="RETURN@dbUIMsg"
                          shortDescBinding="RETURN@dbUIMsg"
                          destinationBinding="cancelURL@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>                
	    </uix:pageLayout>			
    </uix:body>
   </uix:document>
 </uix:renderingContext>
     
    
