<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchStep.jsp
 *
 *      NOTES
 *       jsp for continue to next synch step after clicking on a
 *       'Continue To Script Generation/Execution/Regeneration' button/url
 *       or to retry previous step after clicking
 *   	 'Retry Script Execution' button/url.
 *       Bean key is 'synchStepBean'.       
 *
 * MODIFIED
 *    mahessub      01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub      08/05/08 - Synch Script Regeneration
 *    mahessub      05/13/08 - Merge 11GC functionality.
 *    mahessub      04/25/07 - Added step to Retry Script Execution
 *    xshen         12/20/06 - Created.
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg" class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>
<uix:bundle name="credsMsgBundle" class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchStepBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="synchStepForm" 
               method="POST"
               destinationBinding="synchStepDestination@synchStepBean@servletRequest"
               copyParams="cancelURL,backURL,cmCtxType,name,specGuid,specType,target,type,ctxType">
      <uix:formValue name="guid" valueBinding="guid@synchStepBean@servletRequest"/>
      <uix:formValue name="version" valueBinding="version@synchStepBean@servletRequest"/>
      <uix:formValue name="pageName" value="/database/changemgr/synch/synchStep"/>

        <uix:pageLayout titleBinding="titleString@synchStepBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="/database/changemgr/cmMsging.jspf" %>   
          <%@ include file="/database/changemgr/synch/synchVersionCommIncl.jspf" %>

		<!-- Instruction text -->
		<uix:tableLayout width="100%">
			<uix:rowLayout>
			  <uix:cellFormat>
		        <uix:spacer height="5"/>
			  </uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout>
			  <uix:cellFormat>
		        <uix:messagePrompt promptBinding="instructionString@synchStepBean@servletRequest"/>
			  </uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout>
			  <uix:cellFormat>
		        <uix:spacer height="6"/>
			  </uix:cellFormat>
			</uix:rowLayout>
		</uix:tableLayout>
		
          <uix:labeledFieldLayout labelWidth="30%">
            <uix:messageTextInput shortDescBinding="JOB_NAME@cmUIMsg"
                                  promptBinding="JOB_NAME@cmUIMsg"
                                  required="uiOnly"
                                  name="jobName"
                                  columns="50"
                                  maximumLength="40"
                                  textBinding="jobName@synchStepBean@servletRequest"/>
            <uix:messageTextInput shortDescBinding="DESCRIPTION@cmUIMsg"
                                  promptBinding="DESCRIPTION@cmUIMsg"
                                  name="jobDescription"
                                  columns="50"
                                  textBinding="jobDescription@synchStepBean@servletRequest"/>
          </uix:labeledFieldLayout>          

          <!-- Host Credential: Execution step only -->
          <uix:header textBinding="DESTINATION_HOST_CREDS@cmUIMsg" renderedBinding="renderHostCreds@synchStepBean@servletRequest">

            <uix:labeledFieldLayout labelWidth="28%">
	      <uix:contents>
		<uix:messageTextInput name="userName" 
	             promptBinding="CREDS_HOST_USER@credsMsgBundle"
		     textBinding="userName@synchHostCredsBean@servletRequest" 
		     disabledBinding="userNameDisabled@synchHostCredsBean@servletRequest"
		     messageBinding="userNameError@synchHostCredsBean@servletRequest" 
		     messageTypeBinding="userNameErrorType@synchHostCredsBean@servletRequest" 
		     noAutoComplete="true"           
		     columns="50"
		     required="uiOnly"/>
		<uix:messageTextInput name="secretPassword" 
		     promptBinding="CREDS_HOST_PASSWORD@credsMsgBundle" 
		     textBinding="secretPassword@synchHostCredsBean@servletRequest" 
		     messageBinding="passwordError@synchHostCredsBean@servletRequest" 
		     messageTypeBinding="passwordErrorType@synchHostCredsBean@servletRequest" 
		     secret="true"           
		     noAutoComplete="true"           
		     columns="50"
		     required="uiOnly"/>
				                         
        <uix:messagePrompt prompt="" 
             renderedBinding="repMode@synchHostCredsBean@servletRequest"/>
		<uix:checkBox name="savePrefCreds" 
		     renderedBinding="repMode@synchHostCredsBean@servletRequest"
		     shortDescBinding="prefCheck@credsMsgBundle" 
		     disabledBinding="savePrefCredsDisabled@synchHostCredsBean@servletRequest"
		     styleClass="OraFieldText" 
		     textBinding="prefCheck@credsMsgBundle" 
		     checkedBinding="savePrefCreds@synchHostCredsBean@servletRequest"
		     value="true"/>
              </uix:contents>
	    </uix:labeledFieldLayout>                         

        </uix:header>

        <!-- Schedule: Start Only, No Repeating -->
        <%@ include file="/sdk/schedule/start.jspf"%>

        <!-- Submit and Cancel buttons -->
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button
                     shortDescBinding="CANCEL@dbUIMsg"
                     destinationBinding="cancelURL@servletRequest"
                     textBinding="CANCEL@dbUIMsg"/>
                <uix:button
                     renderedBinding="showBackButton@synchStepBean@servletRequest"
                     shortDescBinding="BACK@dbUIMsg"
                     destinationBinding="backURL@servletRequest"
                     textBinding="BACK@dbUIMsg"/>                     
                <uix:submitButton
                     shortDescBinding="SUBMIT@dbUIMsg"
                     name="event"
                     value="submitContinueSynchStep"
                     textBinding="SUBMIT@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>


        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
