<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchWizAddScopeItems.jsp
 *
 *      NOTES
 *       jsp for CM synch UI - Add Scope Spec Items.
 *       Launched from 'Add' on Synch wizard. 
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   05/13/08 - Merge 11GC functionality.
 *    mahessub   09/13/06 - created
 *    mahessub   06/15/04 - Created based on compareWiz
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="synchForm" 
               method="POST"
               destinationBinding="compareDestination@synchBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,target,type,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/synch/synchWizAddScopeItems"/>
      <uix:formValue name="event" 
                     value="addItemsSearch"/>

        <uix:pageLayout 
             titleBinding="titleString@synchBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Train -->
            <uix:location>
              <uix:train selectedIndexBinding="selectedIndex@synchBean@servletRequest">
                <uix:contents>
                  <uix:link textBinding="SOURCE@cmUIMsg"/>
                  <uix:link textBinding="DESTINATION@cmUIMsg"/>
                  <uix:link textBinding="OBJECTS@cmUIMsg"/>
                  <uix:link textBinding="OPTIONS@cmUIMsg"/>
                  <!--  uix:link textBinding="DATA_COPY@cmUIMsg"-->
                  <uix:link textBinding="JOB_OPTIONS@cmUIMsg"/>
                  <uix:link textBinding="REVIEW@cmUIMsg"/>
                </uix:contents>
              </uix:train>
            </uix:location>

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:rowLayout width="100%">
               <uix:labeledFieldLayout>
                <uix:contents>
                  <uix:messagePrompt
                       promptBinding="SOURCE@cmUIMsg"/>
                  <uix:styledText
                       styleClass="OraDataText"
                       textBinding="leftSummaryDisplay@synchBean@servletRequest"/>
                  <uix:messagePrompt
		       renderedBinding="sourceDatabase@synchBean@servletRequest"
                       promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
		       renderedBinding="sourceDatabase@synchBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="sourceTgtUser@synchBean@servletRequest"/>
                </uix:contents>
               </uix:labeledFieldLayout>
               <uix:labeledFieldLayout renderedBinding="comparisonExclude@addScopeItems@specifyScope@synchBean@servletRequest">
                <uix:contents>
                  <uix:messagePrompt promptBinding="DESTINATION@cmUIMsg"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="destinationSummaryDisplay@synchBean@servletRequest"/>
                  <uix:messagePrompt renderedBinding="destinationDatabase@synchBean@servletRequest"
		                     promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText renderedBinding="destinationDatabase@synchBean@servletRequest"
		            	     styleClass="OraDataText"
                                     textBinding="destinationTgtUser@synchBean@servletRequest"/>
                </uix:contents>
               </uix:labeledFieldLayout>
             </uix:rowLayout>
            </uix:pageStatus>   

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

	    <!-- Instruction only in Exclude Mode -->
            <uix:rowLayout width="100%" 
                           renderedBinding="excludeMode@synchBean@servletRequest">
              <uix:messagePrompt promptBinding="OBJECTS_ADD_EXCLUDE_SCHEMAS@cmUIMsg"/>
            </uix:rowLayout>
	    <!-- Instruction only in Object Mode -->
            <uix:rowLayout width="100%" 
                           renderedBinding="objectMode@synchBean@servletRequest">
              <uix:messagePrompt promptBinding="SELECT_OBJ_FROM_LEFT@cmUIMsg"/>
            </uix:rowLayout>

            <!-- Add Scope Items Included Page -->
            <%@ include file="/database/changemgr/addScopeItems.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
