<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchWizDestination.jsp
 *
 *      NOTES
 *       jsp for CM synchronization UI - Select Destination
 *       The key to the bean supporting the wizard
 *       is 'synchBean'
 *       
 *
 * MODIFIED
 *    mahessub      01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub      11/26/08 - ada input focus
 *    mahessub      05/13/08 - Merge 11GC functionality.
 *    mahessub      10/13/06 - fix exception on enter key press
 *    mahessub      08/25/06 - Created based on compareWizRHS.jsp
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<!-- Select Database LOV -->
<db:script src="/page/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].target.focus()">
      <db:form name="synchForm" 
               method="POST"
               destinationBinding="synchDestination@synchBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/synch/synchWizDestination"/>
      <uix:formValue name="type" 
                     value="oracle_database"/>
      <uix:formValue name="cancelURL" 
                     valueBinding="dbLoginCancelURL@servletRequest"/>
      <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
        <uix:case name="false">
          <uix:formValue name="target" valueBinding="destinationDBName@synchBean@servletRequest"/>
        </uix:case>
      </uix:switcher>

        <uix:pageLayout 
             titleBinding="titleString@synchBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Synch Train -->
            <%@ include file="/database/changemgr/synch/synchTrain.jspf" %>   

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <uix:pageStatus>
              <uix:labeledFieldLayout width="100%">
                <uix:contents>
                  <uix:messagePrompt
                       promptBinding="SOURCE@cmUIMsg"/>
                  <uix:styledText
                       styleClass="OraDataText"
                       textBinding="sourceSummaryDisplay@synchBean@servletRequest"/>

                  <uix:messagePrompt 
		       renderedBinding="sourceDatabase@synchBean@servletRequest"
                       promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"/>
                  <uix:styledText
		       renderedBinding="sourceDatabase@synchBean@servletRequest"
                      styleClass="OraDataText"
                      textBinding="sourceTgtUser@synchBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:pageStatus>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

		<uix:rowLayout width="100%">
                  <uix:contents>
                    <uix:messagePrompt 
                         promptBinding="SPECIFY_SYNCH_DESTINATION@cmUIMsg"/>
                  </uix:contents>
		</uix:rowLayout>

		<uix:rowLayout width="100%">
                  <uix:contents>
		    <uix:spacer height="4"/>
                  </uix:contents>
		</uix:rowLayout>

        <uix:labeledFieldLayout labelWidth="100">
          <uix:contents>
            <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
               <uix:case name="true">
                <uix:messageLovField
                     promptBinding="DATABASE_TYPE@cmUIMsg"
                     tipBinding="MUST_BE_9I_LATER@cmUIMsg"
                     id="target"
                     name="target"
                     columns="44"
                     textBinding="destinationDBName@synchBean@servletRequest"
                     searchDescBinding="CLICK_TO_SELECT_DATABASE@cmUIMsg"
                     onClick="preserveCase();startLov('target','ListDatabaseCM')"
                     onKeyPress="if(event.keyCode==13) {_navBarSubmit('synchForm','goto','synchNav',1,'3');return false;}"
                     messageBinding="(DATABASE@cmUIMsg)@messages@servletRequest"
                     messageTypeBinding="(DATABASE@cmUIMsg)@messageTypes@servletRequest"/>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
                <uix:case name="false">
                   <uix:messagePrompt promptBinding="DESTINATION@cmUIMsg"/>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
                <uix:case name="false">
                   <uix:styledText styleClass="OraDataText" 
                                   textBinding="destinationDBName@synchBean@servletRequest"/>
                </uix:case>
              </uix:switcher>
	  	    </uix:contents>
		  </uix:labeledFieldLayout>


            <%@ include file="/database/changemgr/synch/synchWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
