<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchWizMode.jsp
 *
 *      NOTES
 *       jsp for CM synchronization UI - Select Mode
 *       The key to the bean supporting the wizard
 *       is 'synchBean'
 *       
 *
 * MODIFIED
 *    mahessub      01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub      05/13/08 - Merge 11GC functionality.
 *    xshen         12/14/06 - synch ui dev
 *    mahessub      12/11/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>
<uix:bundle name="credsMsgBundle"
            class="oracle.sysman.resources.eml.creds.PrefCredsMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="document.forms[0].userName.focus()">
      <db:form name="synchForm" 
               method="POST"
               destinationBinding="synchDestination@synchBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/synch/synchWizMode"/>
      <uix:formValue name="type" 
                     value="oracle_database"/>
      <uix:formValue name="cancelURL" 
                     valueBinding="dbLoginCancelURL@servletRequest"/>

        <uix:pageLayout 
             titleBinding="titleString@synchBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Synch Train -->
            <%@ include file="/database/changemgr/synch/synchTrain.jspf" %>   

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <%@ include file="/database/changemgr/synch/bipartitePS.jspf" %>

            <%-- Synch mode and host credentials --%>
            <%@ include file="/database/changemgr/synch/mode.jspf" %>
            
            <%-- Wizard buttons --%>
            <%@ include file="/database/changemgr/synch/synchWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
