<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchWizReview.jsp
 *
 *      NOTES
 *       jsp for CM synch UI - Review
 *       The key to the bean supporting the wizard
 *       is 'synchBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   05/13/08 - Merge 11GC functionality.
 *    mahessub   09/14/07 - 
 *    xshen      12/27/06 - remove drop dependent obj option
 *    mahessub   10/10/06 - added synch specific options
 *    mahessub   09/06/06 - Created based on compare
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="synchForm" 
               method="POST"
               destinationBinding="synchDestination@synchBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/synch/synchWizReview"/>

        <uix:pageLayout 
             titleBinding="titleString@synchBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

            <!-- Synch Train -->
            <%@ include file="/database/changemgr/synch/synchTrain.jspf" %>   
          
            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <%@ include file="/database/changemgr/synch/bipartitePS.jspf" %>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>

            <!-- Review Comparison Options -->
            <uix:tableLayout width="80%">
              <uix:contents>
                <uix:labeledFieldLayout labelWidth="30%">
                  <uix:contents>
                    <!-- Synch Name -->
                    <uix:messagePrompt
                         promptBinding="SYNCHRONIZATION_NAME@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="newName@synchBean@servletRequest"/>

                    <!-- Capture Source First -->
                    <uix:messagePrompt
                         promptBinding="CAPTURE_FIRST_SOURCE@cmUIMsg"
                         renderedBinding="showReviewSourceCaptureFirst@synchBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="reviewSourceCaptureFirst@synchBean@servletRequest"
                         renderedBinding="showReviewSourceCaptureFirst@synchBean@servletRequest"/>

                    <!-- Description -->
                    <uix:messagePrompt
                         promptBinding="DESCRIPTION@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="newDescription@synchBean@servletRequest"/>

                    <!-- Types: Only Shown if showReviewTypes is true -->
                    <uix:messagePrompt
                         promptBinding="OBJECTTYPES@dbUIMsg"
                         renderedBinding="showReviewTypes@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="selectedTypeString@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewTypes@specifyScopeBean@servletRequest"/>

                    <!-- Schemas: Only Shown if showReviewSchemas is true -->
                    <!-- when getObjectMode is false -->
                    <uix:messagePrompt
                         promptBinding="schemaPrompt@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewSchemas@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="selectedSchemaString@specifyScopeBean@servletRequest"
                         renderedBinding="showReviewSchemas@specifyScopeBean@servletRequest"/>

                    <!-- Patterns: Only Shown if showPrefixPattern is true -->
                    <!-- when getObjectMode is false -->
                    <uix:messagePrompt
                         promptBinding="OBJNAME_STARTSWITH@cmUIMsg"
                         renderedBinding="showPrefixPattern@specifyScopeBean@servletRequest"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="prefixInputString@specifyScopeBean@servletRequest"
                         renderedBinding="showPrefixPattern@specifyScopeBean@servletRequest"/>
      
                    <!-- Schema Map: Only show non-identity mappings -->
                    <uix:messagePrompt
			 renderedBinding="showSchemaMapString@synchBean@servletRequest"
                         promptBinding="SCHEMA_MAP@cmUIMsg"/>
                    <uix:styledText
			 renderedBinding="showSchemaMapString@synchBean@servletRequest"
                         styleClass="OraDataText"
                         textBinding="schemaMapString@synchBean@servletRequest"/>

                    <!-- Synch Options -->
                    <uix:messagePrompt
                         promptBinding="IGNORE_PHYSICAL@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignorePhysicalString@synchBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="IGNORE_TABLESPACE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignoreTbspString@synchBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="MATCH_CONSTRAINTS@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="matchConsString@synchBean@servletRequest"/>
                    <uix:messagePrompt 
                         renderedBinding="showReportNameDiff@synchBean@servletRequest"
                         promptBinding="REPORT_NAME_DIFF@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         renderedBinding="showReportNameDiff@synchBean@servletRequest"
                         textBinding="reportNameDiffString@synchBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="IGNORE_TBLCOL_NUM@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignoreTblColNumString@synchBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="IGNORE_HIGH_VALUES@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="ignorePartitionString@synchBean@servletRequest"/>
                    <uix:messagePrompt
                         promptBinding="LOGICAL_SQL_COMPARE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="logicalSQLString@synchBean@servletRequest"/>

                    <!-- options only in synch, not compare -->
                    <uix:messagePrompt
                         promptBinding="TABLE_DATA@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="copyDataString@synchBean@servletRequest"/>

                    <uix:messagePrompt
                         promptBinding="DROP_DESTINATION_ONLY_OBJECTS@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="dropDestinationOnlyObjectsString@synchBean@servletRequest"/>
 
                    <uix:messagePrompt
                         promptBinding="MODE@cmUIMsg"/>
                    <uix:styledText
                         styleClass="OraDataText"
                         textBinding="synchModeString@synchBean@servletRequest"/>
                  </uix:contents>
                </uix:labeledFieldLayout>        
              </uix:contents>
            </uix:tableLayout>

            <!-- Object Table: Only Shown if showReviewObjects is true -->

            <uix:header textBinding="OBJECTS_TO_INCLUDE@cmUIMsg" 
                        renderedBinding="showReviewObjects@specifyScopeBean@servletRequest">
              <uix:table width="70%"
                         summaryBinding="OBJECTS_TO_INCLUDE@cmUIMsg"
                         partialRenderMode="self"
                         id="selectedItemsTable"
                         name="selectedItemsTable"
                         alternateTextBinding="alternateText@specifyScopeBean@servletRequest"
                         formSubmitted="true"
                         valueBinding="value@specifyScopeBean@servletRequest"
                         maxValueBinding="maxValue@specifyScopeBean@servletRequest"
                         blockSize="10"
                         tableDataBinding="selectedItems@specifyScopeBean@servletRequest"
                         columnHeaderDataBinding="columnHeaders@specifyScopeBean@servletRequest" 
                         columnFormatsBinding="columnFormats@specifyScopeBean@servletRequest">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader textBinding="text"
                                              valueBinding="value"
                                              sortableBinding="sort"/>
                        </uix:columnHeaderStamp>
                        <uix:contents>
                          <uix:styledText textBinding="sname"/>
                          <uix:styledText textBinding="oname"/>
                          <uix:styledText textBinding="otype"/>
                        </uix:contents>
              </uix:table>
            </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="cancelSynchronize"
                    textBinding="CANCEL@dbUIMsg"/>
                <uix:navigationBar
                    name="synchNav"
                    blockSize="-1"
                    minValue="1"
                    maxValueBinding="maxStepValue@synchBean@servletRequest"
                    valueBinding="stepValue@synchBean@servletRequest"
                    formSubmitted="true"
                    formName="synchForm"
                    destinationBinding="synchDestination@synchBean@servletRequest"/>
                <uix:submitButton
                    name="event"
                    value="finishSynchronize"
                    shortDescBinding="SUBMIT@dbUIMsg"
                    textBinding="SUBMIT@dbUIMsg"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
