<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchWizRules.jsp
 *
 *      NOTES
 *       jsp for CM synch UI - Synch Rules
 *       The key to the bean supporting the wizard
 *       is 'synchBean'
 *       
 *
 * MODIFIED
 *    mahessub    01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub    05/13/08 - Merge 11GC functionality.
 *    mahessub    10/10/06 - Removed statistics option
 *    mahessub    10/10/06 - Added copy data option
 *    mahessub    09/05/06 - Created based on compare
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="synchForm" 
               method="POST"
               destinationBinding="synchDestination@synchBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/synch/synchWizRules"/>

        <uix:pageLayout 
             titleBinding="titleString@synchBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Synch Train -->
            <%@ include file="/database/changemgr/synch/synchTrain.jspf" %>   

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   

            <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
            <%@ include file="/database/changemgr/synch/bipartitePS.jspf" %>

            <%-- Follow page/wizard context information with a separator --%>
            <uix:separator/>
            <uix:tableLayout width="80%" cellSpacing="10">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="STORAGE@cmUIMsg"/>
 		        </uix:cellFormat>
                <uix:cellFormat hAlign="left" >
                  <uix:stackLayout>
                    <uix:checkBox name="ignorePhysical"
                                textBinding="IGNORE_PHYSICAL@cmUIMsg"
                                checkedBinding="ignorePhysical@synchBean@servletRequest"/>
                    <uix:checkBox name="ignoreTbsp"
                                textBinding="IGNORE_TABLESPACE@cmUIMsg"
                                checkedBinding="ignoreTbsp@synchBean@servletRequest"/>
                    <uix:tip>
                      <uix:styledText textBinding="IGNORE_TABLESPACE_TIP@cmUIMsg"/>
                    </uix:tip>                                
 	          </uix:stackLayout>
     	        </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="CONSTRAINTS@cmUIMsg"/>
 		        </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:stackLayout>
                    <uix:radioButton name="matchCons" 
                                 value="BY_DEFINITION" 
                                 selectedValueBinding="matchCons@synchBean@servletRequest"
                                 textBinding="MATCH_BY_DEFINITION@cmUIMsg"/>
                    <uix:rowLayout>
                      <uix:spacer width="17"/>
                      <uix:cellFormat wrappingDisabled="true">
                      <uix:checkBox name="reportNameDiff"
                                  textBinding="REPORT_NAME_DIFF@cmUIMsg"
                                  checkedBinding="reportNameDiff@synchBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
 	
 	                 <uix:radioButton name="matchCons" 
                                  value="BY_NAME" 
                                  selectedValueBinding="matchCons@synchBean@servletRequest"
                                  textBinding="MATCH_BY_NAME@cmUIMsg"/>
                     <uix:tip>
                       <uix:styledText textBinding="MATCH_BY_NAME_TIP@cmUIMsg"/>
                     </uix:tip>
                  </uix:stackLayout>       
 		        </uix:cellFormat>
              </uix:rowLayout>
 		     
      	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">                  
                    <uix:messagePrompt promptBinding="PARTITIONED_OBJECTS@cmUIMsg"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:checkBox name="ignorePartition"
                              textBinding="IGNORE_HIGH_VALUES@cmUIMsg"
                              checkedBinding="ignorePartition@synchBean@servletRequest"/>
                 </uix:cellFormat>
               </uix:rowLayout>  
                 
               <uix:rowLayout>
                 <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true"> 
                    <uix:messagePrompt promptBinding="TABLE_DATA@cmUIMsg"/>
                 </uix:cellFormat> 
                 <uix:cellFormat>
                   <uix:stackLayout>
	                 <uix:radioButton name="copyData" 
	                           value="PRESERVE_DATA" 
	                           selectedValueBinding="copyData@synchBean@servletRequest"
	                           textBinding="PRESERVE_DATA@cmUIMsg"
	                           disabledBinding="copyDataDisabled@synchBean@servletRequest"/>
                     <uix:radioButton name="copyData" 
	                           value="COPY_DATA" 
	                           selectedValueBinding="copyData@synchBean@servletRequest"
	                           textBinding="COPY_DATA@cmUIMsg"
	                           disabledBinding="copyDataDisabled@synchBean@servletRequest"/>
                     <uix:tip>
                       <uix:styledText textBinding="COPY_DATA_TIP@cmUIMsg"/>
                     </uix:tip>
                   </uix:stackLayout>
                 </uix:cellFormat>
               </uix:rowLayout> 
               
               <uix:rowLayout> 
                 <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                    <uix:messagePrompt promptBinding="SOURCE_TYPE_OBJECTS@cmUIMsg"/>  
                 </uix:cellFormat> 
                 <uix:cellFormat>                          
                    <uix:checkBox name="logicalSQL"
                                  textBinding="LOGICAL_SQL_COMPARE@cmUIMsg"
                                  checkedBinding="logicalSQL@synchBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

      	      <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                    <uix:messagePrompt promptBinding="OTHER_RULES@cmUIMsg"/>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:stackLayout>
                    <uix:checkBox name="ignoreTblColNum"
                              textBinding="IGNORE_TBLCOL_NUM@cmUIMsg"
                              checkedBinding="ignoreTblColNum@synchBean@servletRequest"/>                                
                    <uix:checkBox name="dropDestinationOnlyObjects"
                              textBinding="DROP_DESTINATION_ONLY_OBJECTS@cmUIMsg"
                              checkedBinding="dropDestinationOnlyObjects@synchBean@servletRequest"/>
                    <uix:tip>
                      <uix:styledText textBinding="DROP_DESTINATION_ONLY_OBJECTS_TIP@cmUIMsg"/>
                    </uix:tip>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
	    </uix:tableLayout>
	    
	    <%@ include file="/database/changemgr/synch/synchWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
