<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       synchWizSource.jsp
 *
 *      NOTES
 *       jsp for CM synchronize UI - Select Sync Source 
 *       The key to the bean supporting the wizard
 *       is 'synchBean'
 *       
 *
 * MODIFIED
 *    mahessub      01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub      11/26/08 - ada input focus
 *    mahessub      05/13/08 - Merge 11GC functionality.
 *    mahessub      06/15/04 - Created based on comparison wizard
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<!-- Select Database LOV -->
<db:script src="/page/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@synchBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="document.forms[0].newName.focus()">
      <db:form name="synchForm" 
               method="POST"
               destinationBinding="synchDestination@synchBean@servletRequest"
               copyParams="cmCtxType,guid,specGuid,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/synch/synchWizSource"/>
      <uix:formValue name="type" 
                     valueBinding="sourceTargetType@synchBean@servletRequest"/>
      <uix:formValue name="cancelURL" 
                     valueBinding="dbLoginCancelURL@servletRequest"/>
      <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
        <uix:case name="false">
          <uix:formValue name="target" valueBinding="sourceDBName@synchBean@servletRequest"/>
        </uix:case>
      </uix:switcher>

        <uix:pageLayout 
             titleBinding="titleString@synchBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
            <!-- Synch Train -->
            <%@ include file="/database/changemgr/synch/synchTrain.jspf" %>   

            <!-- Messaging Area -->
            <%@ include file="/database/changemgr/cmMsging.jspf" %>   
            
            <uix:tableLayout width="100%">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:spacer height="3"/>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:borderLayout>

                      <%-- Right side of borderLayout --%>
                      <uix:right>
                        <uix:contentContainer
                            textBinding="OVERVIEW@cmUIMsg"
                            width="400">
                          <uix:contents>
                            <uix:stackLayout>
                              <uix:contents>
                                <uix:styledText styleClass="OraInstructionText"
                                    textBinding="SYNCH_OVERVIEW_MSG1@cmUIMsg"/>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:contentContainer>
                      </uix:right>

                      <%-- Inner Right: putting sufficient spacer --%>
                      <uix:innerRight>
                        <uix:tableLayout width="10%">
                          <uix:rowLayout>
                            <uix:spacer width="10"/>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:innerRight>

                      <%-- Contents of borderLayout --%>
                      <uix:contents>
                       <uix:labeledFieldLayout fieldWidth="80%" labelWidth="145">
    				    <!-- synchronization name -->                       
                        <uix:rowLayout>
                          <uix:cellFormat wrappingDisabled="true" hAlign="right">
                            <uix:messagePrompt promptBinding="SYNCHRONIZATION_NAME@cmUIMsg" 
                                               required="uiOnly"/>
						  </uix:cellFormat>
  					    </uix:rowLayout>
                        <uix:textInput
                             shortDescBinding="SYNCHRONIZATION_NAME@cmUIMsg"
                             required="uiOnly"
                             name="newName"
                             maximumLength="30"
                             columns="44"
                             textBinding="newName@synchBean@servletRequest"/>
  					     <!-- description -->
                         <uix:messagePrompt promptBinding="DESCRIPTION@cmUIMsg"/>
                         <uix:textInput shortDescBinding="DESCRIPTION@cmUIMsg"
                                         name="newDescription"
                                         columns="44"
		 			      	             rows="3"
                                         textBinding="newDescription@synchBean@servletRequest"/>
				  </uix:labeledFieldLayout>
				  
		        <uix:rowLayout width="100%">
                          <uix:contents>
			    			<uix:spacer height="4"/>
                          </uix:contents>
			    </uix:rowLayout>

		        <uix:rowLayout width="100%">
                          <uix:contents>
			    			<uix:messagePrompt 
                                 promptBinding="SPECIFY_SYNCH_SOURCE@cmUIMsg"/>
                          </uix:contents>
			    </uix:rowLayout>
			    
			    <uix:rowLayout width="100%">
                          <uix:contents>
		                    <uix:tip>
		                      <uix:styledText textBinding="SPECIFY_SYNCH_SOURCE_TIP@cmUIMsg"/>
		                    </uix:tip>
                          </uix:contents>
			    </uix:rowLayout>
   
		        <uix:rowLayout width="100%">
                          <uix:contents>
			    			<uix:spacer height="4"/>
                          </uix:contents>
			    </uix:rowLayout>

		        <uix:rowLayout width="100%">
                          <uix:contents>
                            <uix:radioButton name="sourceType" 
                                 value="D" 
                                 selectedValueBinding="sourceType@synchBean@servletRequest"
                                 textBinding="RUNNING_INSTANCE@cmUIMsg"/>
                          </uix:contents>
			    </uix:rowLayout>
			    
                <uix:labeledFieldLayout fieldWidth="80%" labelWidth="145">
                  <uix:contents>
                    <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
                      <uix:case name="true">
                        <uix:messageLovField
                         promptBinding="DATABASE_TYPE@cmUIMsg"
                         id="target"
                         name="target"
                         columns="44"
                         tipBinding="MUST_BE_9I_LATER@cmUIMsg"
                         textBinding="sourceDBName@synchBean@servletRequest"
                         searchDescBinding="CLICK_TO_SELECT_DATABASE@cmUIMsg"
                         onClick="preserveCase();startLov('target','ListDatabaseCM')"
                         messageBinding="(DATABASE@cmUIMsg)@messages@servletRequest"
                         messageTypeBinding="(DATABASE@cmUIMsg)@messageTypes@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
                      <uix:case name="false">
                        <uix:messagePrompt promptBinding="SOURCE_DATABASE@cmUIMsg"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="enterpriseMode@synchBean@servletRequest">
                      <uix:case name="false">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="sourceDBName@synchBean@servletRequest"/>
                      </uix:case>
                  </uix:switcher>
               </uix:contents>
             </uix:labeledFieldLayout>

		     <uix:rowLayout width="100%">
               <uix:contents>
                 <uix:radioButton name="sourceType" 
                      value="B" 
                      selectedValueBinding="sourceType@synchBean@servletRequest"
                      textBinding="SAVED_BASELINE_VERSION@cmUIMsg"/>
               </uix:contents>
			</uix:rowLayout>

			<uix:labeledFieldLayout fieldWidth="80%" labelWidth="145">
               <uix:contents>
                 <uix:messageLovInput 
                      promptBinding="BASELINE_NFMT@cmUIMsg"
                      tipBinding="SAVED_BASELINE_VERSION_TIP@cmUIMsg"
                      id="sourceBLName"
                      name="sourceBLName"
                      columns="44"
                      textBinding="sourceBLName@synchBean@servletRequest"
                      searchDescBinding="CLICK_TO_SELECT_BASELINE@cmUIMsg"
                      destinationBinding="selectBLVersionDest@synchBean@servletRequest"
                      messageBinding="(BASELINE_NAME@cmUIMsg)@messages@servletRequest"
                      messageTypeBinding="(BASELINE_NAME@cmUIMsg)@messageTypes@servletRequest"/>
                 <!-- Capture Before Synch -->
                 <uix:messagePrompt prompt=""/>
                 <uix:stackLayout>
                   <uix:contents>
                     <uix:checkBox name="sourceCaptureFirst"
                      textBinding="CAPTURE_FIRST_BEFORE_SYNCHRONIZE@cmUIMsg"
                      disabledBinding="sourceCaptureFirstDisabled@synchBean@servletRequest"
                      checkedBinding="sourceCaptureFirst@synchBean@servletRequest"/>
                     <uix:messageText
                          messageBinding="(CAPTURE_FIRST_BEFORE_SYNCHRONIZE@cmUIMsg)@messages@servletRequest"
                          messageTypeBinding="(CAPTURE_FIRST_BEFORE_SYNCHRONIZE@cmUIMsg)@messageTypes@servletRequest"/>     
                   </uix:contents>
                 </uix:stackLayout>
	  		  </uix:contents>
		    </uix:labeledFieldLayout>

                      </uix:contents>
                    </uix:borderLayout>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <%@ include file="/database/changemgr/synch/synchWizPageButtons.jspf" %>   

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
