<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       viewBLObjHistory.jsp
 *
 *      NOTES
 *       The jsp for a baseline object's version history. 
 *       The key to the bean supporting this view is 
 *       'viewBLObjHistoryBean'.
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   09/15/08 - put back Return button
 *    xshen      02/15/07 - XbranchMerge xshen_cm_bugs from st_emdbsa_11.1
 *    xshen      07/05/05 - fix selection binding 
 *    xshen      06/30/05 - xshen_changemgr_history
 *    xshen      06/29/05 - Created.
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              
    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@viewBLObjHistoryBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="blObjHistoryForm" 
               method="POST"
               destinationBinding="blObjHistDestination@viewBLObjHistoryBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,guid,version,specGuid,specType,target,type,objectName,objectType,objectSchema,ctxType,previousVersion,diffMode,launchCtx">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/viewBLObjHistory"/>

        <uix:pageLayout 
             titleBinding="titleString@viewBLObjHistoryBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <!-- Messaging Area -->
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

        <!-- General Section -->
        <uix:labeledFieldLayout columns="2" width="80%">
          <uix:contents>
                <uix:messagePrompt promptBinding="OBJECT_TYPE@dbUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="objectTypeDisplayString@viewBLObjHistoryBean@servletRequest"/>

                <uix:messagePrompt promptBinding="BASELINE_NFMT@cmUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="blName@viewBLObjHistoryBean@servletRequest"/>                                                       

                <uix:messagePrompt promptBinding="SCHEMA@dbUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="objectSchemaDisplayString@viewBLObjHistoryBean@servletRequest"/>                                                       

                <uix:messagePrompt promptBinding="SOURCE@dbUIMsg"/>
                <uix:styledText styleClass="OraDataText"
                                textBinding="source@viewBLObjHistoryBean@servletRequest"/>                       

          </uix:contents>
        </uix:labeledFieldLayout>
	
            <!-- Show Versions Section -->
            <uix:header textBinding="VERSIONS@cmUIMsg">              
              <oem:table name="versionHistTable"
                         id="versionHistTable"
                         summaryBinding="VERSIONS@cmUIMsg"
                         width="80%"
                         blockSize="25"
                         beanKey="viewBLObjHistoryBean"
                         formSubmitted="true"
                         dataSourceProp="versionHistTable"
                         alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg">
              </oem:table>
            </uix:header>

            <!-- Version History -->
      <uix:hideShowHeader 
           renderedBinding="showCompareObjVersions@viewBLObjHistoryBean@servletRequest"
           id="compareObjVersions"
           formSubmitted="true"
	   formName="blObjHistoryForm"
           disclosedBinding="compareObjVersionsDiscolsed@viewBLObjHistoryBean@servletRequest"
           partialRenderMode="self"
           unvalidated="true"
           textBinding="COMPARE_OBJECT_VERSIONS@cmUIMsg">
        <uix:contents>
          <uix:rowLayout width="100%">
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="COMPARE_OBJ_VER_TIP@cmUIMsg"/>
          </uix:rowLayout>
          <uix:spacer height="2"/>
          <uix:rowLayout width="100%">
            <!-- Left -->
            <uix:cellFormat width="20%" hAlign="right">
              <uix:messagePrompt promptBinding="LEFT_BASELINE@cmUIMsg"/>
            </uix:cellFormat>
              <uix:spacer width="5"/>
            <uix:cellFormat width="20%" hAlign="left">
              <uix:choice name="leftVersion"
                          shortDescBinding="LEFT_BASELINE@cmUIMsg"
                          id="leftVersion"
                          selectedValueBinding="leftVersion@viewBLObjHistoryBean@servletRequest">
                <uix:contents childDataBinding="availableBLVersions@viewBLObjHistoryBean@servletRequest">
                  <uix:option textBinding="text" valueBinding="value"/>
                </uix:contents>
              </uix:choice>
            </uix:cellFormat>

            <uix:spacer width="20"/>

            <!-- Right -->
            <uix:cellFormat width="20%" hAlign="right">
              <uix:messagePrompt promptBinding="RIGHT_BASELINE@cmUIMsg"/>
            </uix:cellFormat>
              <uix:spacer width="5"/>
            <uix:cellFormat width="20%" hAlign="left">
              <uix:choice name="rightVersion"
                          shortDescBinding="RIGHT_BASELINE@cmUIMsg"
                          id="rightVersion"
                          selectedValueBinding="leftVersion@viewBLObjHistoryBean@servletRequest">
                <uix:contents childDataBinding="availableBLVersions@viewBLObjHistoryBean@servletRequest">
                  <uix:option textBinding="text" valueBinding="value"/>
                </uix:contents>
              </uix:choice>
            </uix:cellFormat>

            <!-- Compare -->
            <uix:cellFormat hAlign="right">
              <uix:submitButton textBinding="COMPARE@cmUIMsg"
                                shortDescBinding="COMPARE@cmUIMsg"
                                name="event"
                                value="compareBLObjVersion"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:contents>
      </uix:hideShowHeader>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="RETURN@dbUIMsg"
                          shortDescBinding="RETURN@dbUIMsg"
                          destinationBinding="cancelURL@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
