<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       viewComment.jsp
 *
 *      NOTES
 *       jsp for View Comment Page.
 *       The bean key of the supporting model
 *       is 'viewCommentBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   09/15/08 - put back Return button
 *    xshen      02/15/07 - XbranchMerge xshen_cm_bugs from st_emdbsa_11.1
 *    xshen      05/17/05 - xshen_bug-4373232
 *    xshen      05/10/05 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@viewCommentBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="viewCommentForm" 
               method="POST"
               destinationBinding="viewCommentDest@viewCommentBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,guid,version,specGuid,specType,target,type,objectName,objectType,objectSchema,ctxType">
      <uix:formValue name="pageName" 
                     value="/database/changemgr/viewComment"/>

        <uix:pageLayout 
             titleBinding="titleString@viewCommentBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

        <!-- Comparison Information -->
        <uix:labeledFieldLayout columns="2" width="80%">
          <uix:contents>
          <!-- comparison / version -->
          <uix:messagePrompt promptBinding="COMPARISON_NFMT@cmUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="comparisonNameDisplay@viewCommentBean@servletRequest"/>
          <!-- comparison owner -->
          <uix:messagePrompt promptBinding="OWNER@cmUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="owner@viewCommentBean@servletRequest"/>
          <!-- left source name -->
          <uix:messagePrompt promptBinding="LEFT_SOURCE@cmUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="leftSourceDisplay@viewCommentBean@servletRequest"/>
          <!-- right source name -->
          <uix:messagePrompt promptBinding="RIGHT_SOURCE@cmUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="rightSourceDisplay@viewCommentBean@servletRequest"/>
          <!-- left type  -->
          <uix:messagePrompt promptBinding="LEFT_TYPE@cmUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="leftTypeDisplay@viewCommentBean@servletRequest"/>
          <!-- right type  -->
          <uix:messagePrompt promptBinding="RIGHT_TYPE@cmUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="rightTypeDisplay@viewCommentBean@servletRequest"/>
          <!-- object type -->
          <uix:messagePrompt promptBinding="OBJECT_TYPE@dbUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="objectType@viewCommentBean@servletRequest"/>
          <!-- schema -->
          <uix:messagePrompt promptBinding="SCHEMA@dbUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="objectSchema@viewCommentBean@servletRequest"/>
          <!-- object name -->
          <uix:messagePrompt promptBinding="OBJECT_NAME@dbUIMsg"/>
          <uix:styledText styleClass="OraDataText"
               textBinding="objectName@viewCommentBean@servletRequest"/>
          <!-- comparison results -->
          <uix:messagePrompt
               promptBinding="COMPARISON_RESULT@cmUIMsg"/>
          <uix:image sourceBinding="comparisonResult@viewCommentBean@servletRequest"
                     shortDescBinding="RESULT@cmUIMsg"/>  
         </uix:contents>
        </uix:labeledFieldLayout>

        <!-- Add One Comment and Comment Table -->
        <uix:separator/>
        <%@ include file="/database/changemgr/addOneComment.jspf" %>   

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="RETURN@dbUIMsg"
                            shortDescBinding="RETURN@dbUIMsg"
                            destinationBinding="cancelURL@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
