<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       viewVersionChanges.jsp
 *
 *      NOTES
 *       jsp for a list of Changed/Unchanged/New/Removed objects
 *       between 2 baseline versions.
 *       The bean key of the supporting model
 *       is 'viewVersionChangesBean'
 *       
 *
 * MODIFIED
 *    mahessub   01/16/09 - Copy 10.2.0.5GC on top of 11.2 DB Control
 *    mahessub   09/15/08 - put back return button
 *    mahessub   10/24/07 - 
 *    xshen      02/15/07 - XbranchMerge xshen_cm_bugs from st_emdbsa_11.1
 *    xshen      06/30/05 - xshen_changemgr_history
 *    xshen      06/23/05 - Created 
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<!-- Select Schemas lov -->
<db:script src="/page/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="cmUIMsg"
            class="oracle.sysman.db.rsc.cm.ChangeMgrCommonMsg"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@viewVersionChangesBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="versionChangesForm" 
               method="POST"
               destinationBinding="versionChangesDest@viewVersionChangesBean@servletRequest"
               copyParams="cancelURL,cmCtxType,name,specGuid,specType,target,type,ctxType">
      <uix:formValue name="guid" valueBinding="guid@viewVersionChangesBean@servletRequest"/>
      <uix:formValue name="version" valueBinding="versionStr@viewVersionChangesBean@servletRequest"/>
      <uix:formValue name="previousVersion" valueBinding="previousVersionStr@viewVersionChangesBean@servletRequest"/>
      <uix:formValue name="pageName" 
                     value="/database/changemgr/viewVersionChanges"/>

        <uix:pageLayout 
             titleBinding="titleString@viewVersionChangesBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/database/changemgr/cmMsging.jspf" %>   

    <!-- Left label value pairs -->
    <uix:labeledFieldLayout labelWidth="340">
      <uix:contents>

	<!-- Previous Version -->
        <uix:messagePrompt 
             promptBinding="PREVIOUS_VERSION@cmUIMsg"/>
        <uix:styledText
             styleClass="OraDataText"
             textBinding="previousVersionStr@viewVersionChangesBean@servletRequest"/>

	<!-- Source Database -->
        <uix:messagePrompt 
             promptBinding="SOURCE_DATABASE@cmUIMsg"/>
        <uix:styledText
             styleClass="OraDataText"
             textBinding="source@viewVersionChangesBean@servletRequest"/>

	<!-- Creation Date -->
        <uix:messagePrompt 
             promptBinding="CREATION_DATE@cmUIMsg"/>
        <uix:styledText
             styleClass="OraDataText"
             textBinding="creationDate@viewVersionChangesBean@servletRequest"/>

      </uix:contents>
    </uix:labeledFieldLayout>

<!-- Begin Objects Change Summary Section -->

 <uix:header textBinding="OBJECTS_CHANGE_SUMMARY@cmUIMsg">
    <uix:labeledFieldLayout columns="4" labelWidth="80" fieldWidth="20" width="750">
     <uix:contents>
      <uix:messagePrompt promptBinding="UNCHANGED@cmUIMsg"/>
      <uix:styledText styleClass="OraDataText"
           textBinding="unchangedCountStr@viewVersionChangesBean@servletRequest"/>

      <uix:messagePrompt promptBinding="CHANGED@cmUIMsg"/>
      <uix:styledText styleClass="OraDataText"
           textBinding="changedCountStr@viewVersionChangesBean@servletRequest"/>

      <uix:messagePrompt promptBinding="NEW@cmUIMsg"/>
      <uix:styledText styleClass="OraDataText"
           textBinding="newCountStr@viewVersionChangesBean@servletRequest"/>

      <uix:messagePrompt promptBinding="REMOVED@cmUIMsg"/>
      <uix:styledText styleClass="OraDataText"
           textBinding="removedCountStr@viewVersionChangesBean@servletRequest"/>

     </uix:contents>
    </uix:labeledFieldLayout>
 </uix:header>

  
<!-- Begin Search Field -->
<uix:header textBinding="OBJECTS@cmUIMsg">
<uix:stackLayout>
  <uix:contents>
    <uix:tableLayout cellSpacing="5">
      <uix:contents>
        <uix:rowLayout>
          <uix:contents>

            <!-- Object Type -->
            <uix:cellFormat>
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt promptBinding="OBJECT_TYPE@dbUIMsg"/>
                    <uix:choice name="searchType"
                                shortDescBinding="OBJECT_TYPE@dbUIMsg"
                                id="searchType"
                                selectedValueBinding="searchType@viewVersionChangesBean@servletRequest">
                      <uix:contents childDataBinding="searchTypes@viewVersionChangesBean@servletRequest">
                        <uix:option textBinding="text" 
                                    valueBinding="value"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

            <!-- Schemas -->
            <uix:cellFormat wrappingDisabled="true">
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt promptBinding="SCHEMA@dbUIMsg"/>
	            <!-- Use Baseline List LOV descriptor -->
                    <uix:lovField shortDescBinding="SCHEMA@dbUIMsg"
                                  id="searchSchema"
                                  name="searchSchema"
                                  columns="40"
                                  textBinding="searchSchema@viewVersionChangesBean@servletRequest"
                                  searchDescBinding="CLICK_TO_SELECT_SCHEMA@cmUIMsg"
                                  onClick="preserveCase();setBindSqlParm('guid');setBindSqlParm('version');setBindSqlParm('version');startLov('searchSchema','ListSchemaBaseline')"/>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

            <!-- Object Names -->
            <uix:cellFormat>
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt promptBinding="OBJECT_NAME@dbUIMsg"/>
                    <uix:textInput id="searchObjectName"
                                   name="searchObjectName"
                                   shortDescBinding="ENTER_OBJECT_NAME@dbUIMsg"
                                   columns="40"
                                   textBinding="searchObjectName@viewVersionChangesBean@servletRequest"/>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

            <uix:cellFormat>
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:messagePrompt prompt=" "/>
                    <uix:spacer height="14"/>
                    <uix:submitButton name="event"
                                      value="search"
                                      shortDescBinding="GO@dbUIMsg"
                                      textBinding="GO@dbUIMsg"/>
                  </uix:contents>
                </uix:stackLayout>    
              </uix:contents>  
            </uix:cellFormat>

          </uix:contents>
        </uix:rowLayout>
      </uix:contents>
    </uix:tableLayout>
  </uix:contents>
</uix:stackLayout>

<uix:separator/>

<uix:tableLayout width="100%">
  <uix:rowLayout vAlign="top" width="100%">
    <uix:messageChoice name="showOption" 
                       id="showOption"
                       shortDescBinding="SHOW@cmUIMsg"
                       promptBinding="SHOW@cmUIMsg"
  	               onChange="submitForm('versionChangesForm',true,{'event':'filterResults'})"
                       selectedValueBinding="showOption@viewVersionChangesBean@servletRequest">
      <uix:contents childDataBinding="showOptions@viewVersionChangesBean@servletRequest">
         <uix:option textBinding="text" valueBinding="value"/>
      </uix:contents>
    </uix:messageChoice>
  </uix:rowLayout>
             <oem:table width="80%"                        
                        name="versionChangesTable"
                        summaryBinding="RESULTS@cmUIMsg"                         
                        destinationBinding="versionChangesDest@viewVersionChangesBean@servletRequest"
                        blockSize="25"
                        beanKey="viewVersionChangesBean"
                        formSubmitted="true"
                        dataSourceProp="versionChangesTable"
                        alternateTextBinding="NO_ITEMS_FOUND@dbUIMsg">
              </oem:table>
  </uix:tableLayout>
</uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="RETURN@dbUIMsg"
                            shortDescBinding="RETURN@dbUIMsg"
                            destinationBinding="cancelURL@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
