<%--
  - FILE
  -   ProvCredsSegment.jsp
  -
  - DESCRIPTION
  -   PageSegment to display the Credentials Section for Provisioning projects.
  -
  - MODIFIED   (MM/DD/YY)
  - rvaidhiy   10/19/07 - for ExtendCluster
  - rvaidhiy   02/06/07  - 
  - suravind   08/17/06  - XbranchMerge suravind_ec_directives from main
  - svijayar   08/12/06  - XbranchMerge svijayar_insinp from main
  - suravind   08/08/06  - XbranchMerge suravind_ec_changes_review_page from
  -                        main
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - suravind   06/10/06  - created
  --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix and oem Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>

    <%--Common UI messages --%>
    <uix:bundle
         name="sdkUIMsg"
         class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <%--ResourceBundle for common labels/headers etc--%>
    <uix:bundle
         name="commonResourceBundle"
         class="oracle.sysman.resources.CommonResourceBundle"/>

    <%--ResourceBundle for labels/headers common to Provisioning Projects --%>
    <uix:bundle
      name="provCommonRB"
      class="oracle.sysman.db.common.ui.rb.ProvCommonRB"/>

     <%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
     <%@ page import='oracle.sysman.db.common.ui.creds.beans.ProvCommonCredentialsSegBean' %>
     <%
       PageSegmentContext psContext
         = (PageSegmentContext) request.getAttribute("pageSegmentContext");

       ProvCommonCredentialsSegBean pageSegBean
         = (ProvCommonCredentialsSegBean) psContext.getPageSegmentBean();
     %>
    <uix:tableLayout cellSpacing="4" width="30%">
      <uix:rowLayout>
        <uix:cellFormat width="50%" vAlign="top">
          <uix:messageRadioButton
               id="<%=pageSegBean.getUsePrefCredsRadioID()%>"
               nameBinding="usePrefCredsRadioID@pageSegmentBean@"
               textBinding="CREDS_SEG_RADIO_USE_PREFERRED@provCommonRB"
               prompt=""
               selectedBinding="prefCredsSel@pageSegmentBean@"
               disabledBinding="prefCredsDisabled@pageSegmentBean@"
               primaryClientActionBinding="onChangePrefCredRdBtn@pageSegmentBean@"
               messageBinding="prefCredMsg@servletRequest"/>
       </uix:cellFormat>
       <uix:cellFormat width="50%" vAlign="top">
         <uix:messageRadioButton
              id="<%=pageSegBean.getOverridePrefCredsRadioID()%>"
              nameBinding="overridePrefCredsRadioID@pageSegmentBean@"
              textBinding="CREDS_SEG_RADIO_OVERRIDE_PREFERRED@provCommonRB"
              prompt=""
              selectedBinding="overridePrefCredsSel@pageSegmentBean@"
              primaryClientActionBinding="onChangeOverridePrefCredRdBtn@pageSegmentBean@"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
    <uix:tableLayout id="<%=pageSegBean.getUsePrefCredsSecID()%>">
      <%-- Use preferred credential section --%>
      <uix:rowLayout renderedBinding="prefCredsSel@pageSegmentBean@">
        <uix:cellFormat>
          <uix:labeledFieldLayout
               width="40%"
               renderedBinding="prefCredsTypeChoiceRendered@pageSegmentBean@">
            <%-- This part is shown only if we use preferred credentials. We can choose between normal and privileged credentials --%>
            <uix:messageChoice
                nameBinding="prefCredsTypeChoiceID@pageSegmentBean@"
                promptBinding="CREDS_SEG_PREF_CHOICE_TEXT@provCommonRB"
                shortDescBinding="CREDS_SEG_PREF_CHOICE_TEXT@provCommonRB"
                selectedValueBinding="prefCredsTypeSel@pageSegmentBean@">
              <uix:contents
                   childDataBinding="prefCredsTypeChoice@pageSegmentBean@">
                <uix:option
                    textBinding="PREF_CREDS_TYPE_TEXT"
                    valueBinding="PREF_CREDS_TYPE_VAL"/>
              </uix:contents>
            </uix:messageChoice>
          </uix:labeledFieldLayout>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
    <uix:tableLayout 
         id="<%=pageSegBean.getOverridePrefCredsSecID()%>" 
         width="100%">
      <%--Override preferred credential section --%>
      <uix:rowLayout
           renderedBinding="overridePrefCredsSel@pageSegmentBean@">
        <uix:tableLayout cellSpacing="10" width="100%">
          <uix:rowLayout  hAlign="start">
            <uix:labeledFieldLayout
                width="1%" 
                 renderedBinding="homeCredsChoiceRendered@pageSegmentBean@">
              <uix:messageChoice
                   nameBinding="homeCredsTypeChoiceID@pageSegmentBean@"             
                   id="<%=pageSegBean.getHomeCredsTypeChoiceID()%>" 
                   promptBinding="CREDS_SEG_HOME_CHOICE_TEXT@provCommonRB"
                   shortDescBinding="CREDS_SEG_HOME_CHOICE_TEXT@provCommonRB"
                   selectedValueBinding="homeCredsChoiceSel@pageSegmentBean@"
                   primaryClientActionBinding="onChangeHomeTypeChoice@pageSegmentBean@">
                <uix:contents
                     childDataBinding="homeCredsChoice@pageSegmentBean@">
                <uix:option
                     textBinding="HOME_CREDS_TYPE_TEXT"
                     valueBinding="HOME_CREDS_TYPE_VAL"/>
                </uix:contents>
              </uix:messageChoice>
            </uix:labeledFieldLayout>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:tableLayout 
                 id="<%=pageSegBean.getAllHomesSecID()%>" 
                 width="60%">
              <uix:rowLayout  hAlign="start"
                   renderedBinding="allHomesOverrideRendered@pageSegmentBean@">
                <uix:labeledFieldLayout width="1%">
                  <uix:messageTextInput columns="20"
                       nameBinding="allHomesUsernameID@pageSegmentBean@"
                       textBinding="sameUserName@pageSegmentBean@"
                       promptBinding="CREDS_SEG_ALL_HOMES_USERNAME@provCommonRB"
                       shortDescBinding="CREDS_SEG_ALL_HOMES_USERNAME@provCommonRB"
                       noAutoComplete="true"
                       maximumLength="255"
                       required="uiOnly"
                       messageTypeBinding="type@allUsernameMsg@"
                       messageBinding="msg@allUsernameMsg@"/>
                  <uix:messageTextInput columns="20"
                       nameBinding="allHomesPasswordID@pageSegmentBean@"
                       textBinding="samePassword@pageSegmentBean@"
                       promptBinding="CREDS_SEG_ALL_HOMES_PASSWORD@provCommonRB"
                       shortDescBinding="CREDS_SEG_ALL_HOMES_PASSWORD@provCommonRB"
                       noAutoComplete="true"
                       maximumLength="255"
                       secret="true"
                       required="uiOnly"
                       messageTypeBinding="type@allPasswordMsg@"
                       messageBinding="msg@allPasswordMsg@"/>
                </uix:labeledFieldLayout>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:tableLayout 
                 id="<%=pageSegBean.getEachHomeSecID()%>" 
                 width="60%">
              <uix:rowLayout
                   hAlign="left"
                   renderedBinding="eachHomeOverrideRendered@pageSegmentBean@">
                <uix:table
                     nameBinding="eachHomeTableID@pageSegmentBean@"
                     id="<%=pageSegBean.getEachHomeTableID()%>"
                     summary="credsTable"
                     partialRenderMode="self"
                     formSubmitted="true"
                     tableDataBinding="rows@pageSegmentBean@"
                     valueBinding="currentValue@pageSegmentBean@"
                     minValueBinding="minValue@pageSegmentBean@"
                     blockSizeBinding="blockSize@pageSegmentBean@"
                     maxValueBinding="maxValue@pageSegmentBean@"
                     columnHeaderDataBinding="columnHeaders@pageSegmentBean@">
                  <uix:columnHeaderStamp>
                    <uix:text
                         textBinding="text">
                    </uix:text>
                  </uix:columnHeaderStamp>
                  <uix:styledText
                       textBinding="PRODUCT_NAME"
                       shortDescBinding="CREDS_SEG_EACH_PRODUCT_TABLE_COLUMN_HOST@provCommonRB"
                       renderedBinding="productColRendered@pageSegmentBean@"/>
                  <uix:styledText 
                       textBinding="TGT_NAME"
                       shortDescBinding="CREDS_SEG_EACH_PRODUCT_TABLE_COLUMN_HOST@provCommonRB"
                       renderedBinding="hostColumnRendered@pageSegmentBean@"/>
                  <uix:styledText 
                       textBinding="HOME_LOC"
                       shortDescBinding="CREDS_SEG_EACH_HOME_TABLE_COLUMN_LOCATION@provCommonRB"
                       renderedBinding="homeColumnRendered@pageSegmentBean@"/>
                  <uix:rowLayout>
                  <uix:messageTextInput
                       name="username"
                       textBinding="USERNAME"
                       noAutoComplete="true"
                       maximumLength="255"
                       required="uiOnly"
                       columns="15"
                       shortDescBinding="CREDS_SEG_EACH_HOME_TABLE_COLUMN_USERNAME@provCommonRB"
                       disabledBinding="USERNAME_DISABLED"
                       messageTypeBinding="USERNAME_MSG_TYPE"
                       messageBinding="USERNAME_MSG"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                  <uix:messageTextInput
                       name="password"
                       noAutoComplete="true"
                       maximumLength="255"
                       secret="true"
                       required="uiOnly"
                       columns="15"
                       shortDescBinding="CREDS_SEG_EACH_HOME_TABLE_COLUMN_PASSWORD@provCommonRB"
                       textBinding="PASSWORD_TEMP"
                       messageTypeBinding="PASSWORD_MSG_TYPE"
                       messageBinding="PASSWORD_MSG"/>
                  </uix:rowLayout>
                </uix:table>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:dataScope>
</oem:pageSegment>
