<%--
  - FILE
  -   ProvScheduleSegment.jsp
  -
  - DESCRIPTION
  -   PageSegment to display the Schedule Section for Provisioning projects.
  -
  - MODIFIED   (MM/DD/YY)
  - rvaidhiy   10/19/07 - for ExtendCluster
  - rvaidhiy   04/04/07 - 
  - suravind   08/18/06  - 
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - vsagar     07/18/06  - 10.2.0.3.0 backport 
  - suravind   04/21/06  - created
  --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix and oem Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>

    <%--Common UI messages --%>
    <uix:bundle
         name="sdkUIMsg"
         class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <%--ResourceBundle for common labels/headers etc--%>
    <uix:bundle
         name="commonResourceBundle"
         class="oracle.sysman.resources.CommonResourceBundle"/>
    <%--  Reource Bundle for Schedule labels and headers --%>
    <uix:bundle
         name="scheduleResourceBundle"
         class="oracle.sysman.eml.rsc.page.seg.sch.scheduleMsg"/>

    <%--ResourceBundle for labels/headers common to Provisioning Projects --%>
    <uix:bundle
      name="provCommonRB"
      class="oracle.sysman.db.common.ui.rb.ProvCommonRB"/>

<%--    <uix:document> --%>
      <%-- Schedule Segment Hide Show header --%>
    <uix:hideShowHeader
           id="schSegHideShowHeader"
           partialRenderMode="self"
           textBinding="hideShowHeaderText@pageSegmentBean@"
           disclosedBinding="hideShowHeaderDisclosed@pageSegmentBean@">
        <uix:spacer height="10"/>
        <%-- Table layout with the Schedule Immediately/Later Radio Buttons --%>
        <uix:tableLayout cellSpacing="4">
          <uix:rowLayout>
            <uix:cellFormat>                 
              <uix:messageRadioButton 
                   id="startNowRadioID"
                   name="schStartOption" 
                   textBinding="IMMEDIATELY@scheduleResourceBundle" 
                   selectedBinding="startNowSelected@pageSegmentBean@" 
                   renderedBinding="startNowRendered@pageSegmentBean@" 
                   primaryClientActionBinding="onClickStartNow@pageSegmentBean@" 
                   shortDescBinding="IMMEDIATELY@scheduleResourceBundle"/>    
            </uix:cellFormat>
            <uix:cellFormat>                   
              <uix:messageRadioButton 
                   id="startLaterRadioID"
                   name="schStartOption" 
                   textBinding="LATER@scheduleResourceBundle" 
                   selectedBinding="startLaterSelected@pageSegmentBean@" 
                   renderedBinding="startLaterRendered@pageSegmentBean@" 
                   primaryClientActionBinding="onClickStartLater@pageSegmentBean@" 
                   shortDescBinding="LATER@scheduleResourceBundle"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>     
        <uix:tableLayout cellSpacing="4" width="45%">
          <uix:rowLayout id="startLaterSecID">
            <uix:cellFormat width="8%"/>
            <uix:cellFormat width="20%">
              <%-- timezone --%>
              <uix:labeledFieldLayout 
                   renderedBinding="startLaterSelected@pageSegmentBean@"
                   labelWidth="30%" 
                   fieldWidth="70%">
                <uix:messageChoice
                    name="scheduleTimezoneChoice"
                    promptBinding="TIME_ZONE@scheduleResourceBundle"
                    shortDescBinding="TIME_ZONE@scheduleResourceBundle"
                    selectedValueBinding="selectedTimeZoneSB@pageSegmentBean@"
                    renderedBinding="timeZoneChoiceRendered@pageSegmentBean@">
                  <uix:contents childDataBinding="timezones@pageSegmentBean@">
                    <uix:option textBinding="text" valueBinding="value"/>
                  </uix:contents>
                </uix:messageChoice>
                <%-- start date --%>
                <uix:messageDateField
                    id="startDate"
                    name="scheduleStartDateField"
                    valueBinding="startDateStr@pageSegmentBean@"
                    promptBinding="START_DATE@scheduleResourceBundle"
                    shortDescBinding="START_DATE@scheduleResourceBundle"
                    messageTypeBinding="type@startDateMsg@"
                    messageBinding="msg@startDateMsg@"
                    columns="12"
                    disabledBinding="readOnlyMode@servletRequest">
                  <uix:onSubmitValidater>
                    <uix:date dateStyle="medium"/>
                  </uix:onSubmitValidater>
                </uix:messageDateField>
                <uix:messagePrompt
                    promptBinding="START_TIME@scheduleResourceBundle"/>
                <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top">
                      <uix:messageTextInput 
                           name="scheduleStartHourInput" 
                           columns="2" 
                           textBinding="startHours@pageSegmentBean@" 
                           shortDescBinding="HOURS@scheduleResourceBundle" 
                           disabledBinding="readOnlyMode@servletRequest" 
                           maximumLength="2" 
                           messageTypeBinding="type@startHourMsg@"
                           messageBinding="msg@startHourMsg@"
                           vAlign="top">
                        <uix:onSubmitValidater>
                          <uix:regExp pattern="[0-9]+"/>
                        </uix:onSubmitValidater>
                        <uix:end>
                          <uix:styledText 
                               styleClass="OraInstructionText" 
                               textBinding="TIME_SEPERATOR@scheduleResourceBundle"/>
                        </uix:end>
                      </uix:messageTextInput>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:messageTextInput 
                           name="scheduleStartMinuteInput" 
                           columns="2" 
                           maximumLength="2" 
                           textBinding="startMinutes@pageSegmentBean@" 
                           shortDescBinding="MINUTES@scheduleResourceBundle" 
                           disabledBinding="readOnlyMode@servletRequest" 
                           messageTypeBinding="type@startMinMsg@"
                           messageBinding="msg@startMinMsg@"
                           vAlign="top">
                        <uix:onSubmitValidater>
                          <uix:regExp pattern="[0-9]+"/>
                        </uix:onSubmitValidater>
                      </uix:messageTextInput>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:messageRadioButton 
                           name="startTimeAMPM" 
                           textBinding="AM_LABEL@scheduleResourceBundle" 
                           selectedValueBinding="startAMPM@pageSegmentBean@" 
                           value="AM_VALUE" 
                           renderedBinding="startAMPMRendered@pageSegmentBean@" 
                           shortDescBinding="AM_LABEL@scheduleResourceBundle"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:messageRadioButton
                          name="startTimeAMPM"
                          textBinding="PM_LABEL@scheduleResourceBundle"
                          selectedValueBinding="startAMPM@pageSegmentBean@"
                          value="PM_VALUE"
                          renderedBinding="startAMPMRendered@pageSegmentBean@"
                          shortDescBinding="PM_LABEL@scheduleResourceBundle"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:labeledFieldLayout>
                <uix:tableLayout width="90%" hAlign="left">
                  <uix:rowLayout>
                    <uix:spacer width="100%" height="10"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat width="20%" rowSpan="2" hAlign="right" vAlign="top">
                      <uix:messagePrompt 
                           promptBinding="GRACE_PERIOD@scheduleResourceBundle"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:messageRadioButton
                           id="gracePeriodIndefiniteRadioID"
                           name="gracePeriod"
                           textBinding="INDEFINITE@scheduleResourceBundle"
                           selectedValueBinding="durationType@pageSegmentBean@"
                           value="indef_duration"
                           primaryClientActionBinding="onChangeGraceInfinite@pageSegmentBean@"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout id="gracePeriodFiniteSecID">
                    <uix:cellFormat>
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:messageRadioButton
                              id="gracePeriodFiniteRadioID"
                              name="gracePeriod"
                              textBinding="END_AFTER@scheduleResourceBundle"
                              selectedValueBinding="durationType@pageSegmentBean@"
                              value="interval_duration"
                              primaryClientActionBinding="onChangeGraceFinite@pageSegmentBean@"/>
                        </uix:cellFormat>
                        <uix:cellFormat width="1"/>
                        <uix:cellFormat>
                          <uix:messageTextInput
                              name="gracePeriodHourInput"
                              columns="2"
                              textBinding="gracePeriodHourInput@pageSegmentBean@"
                              shortDescBinding="HOURS@scheduleResourceBundle"
                              disabledBinding="gracePeriodHoursDisabled@pageSegmentBean@"
                              messageTypeBinding="type@graceHourMsg@"
                              messageBinding="msg@graceHourMsg@"
                              maximumLength="2">
                            <uix:onSubmitValidater>
                              <uix:regExp pattern="[0-9]+"/>
                            </uix:onSubmitValidater>
                            <uix:end>
                              <uix:styledText 
                                   styleClass="OraInstructionText" 
                                   textBinding="HOURS@scheduleResourceBundle"/>
                            </uix:end>
                          </uix:messageTextInput>
                        </uix:cellFormat>
                        <uix:cellFormat width="1"/>
                        <uix:cellFormat>
                          <uix:messageTextInput
                              name="gracePeriodMinuteInput"
                              columns="2"
                              maximumLength="2"
                              messageTypeBinding="type@graceMinMsg@"
                              messageBinding="msg@graceMinMsg@"
                              textBinding="gracePeriodMinuteInput@pageSegmentBean@"
                              disabledBinding="gracePeriodMinutesDisabled@pageSegmentBean@"
                              shortDescBinding="MINUTES@scheduleResourceBundle">
                            <uix:onSubmitValidater>
                              <uix:regExp pattern="[0-9]+"/>
                            </uix:onSubmitValidater>
                            <uix:end>
                              <uix:styledText 
                                   styleClass="OraInstructionText" 
                                   textBinding="MINUTES@scheduleResourceBundle"/>
                            </uix:end>
                          </uix:messageTextInput>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:hideShowHeader>
  </uix:dataScope>
</oem:pageSegment>
