<!---->
<%--
  - FILE
  -   targetSelPageSeg.jsp
  -
  - DESCRIPTION
  -   PageSegment to display table for Target selection.
  -
  - BEAN
  -   oracle.sysman.db.common.targetsel.bean.TargetSelPageSegmentBean
  -
  - MODIFIED   (MM/DD/YY)
  -   rvaidhiy  10/19/07 - for ExtendCluster
  -   rvaidhiy  02/06/07 - 
  -   vsagar    07/18/06 - 10.2.0.3.0 backport 
  -   vsagar    07/18/06 - 10.2.0.3.0 backport 
  -   vsagar    12/29/05  - 
  -   tasingh   10/14/05  - created
  --%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/oemNoscript.jspf" %>

<%--uix and oem Tag Library--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
  <uix:dataScope>

    <%--Common UI messages --%>
    <uix:bundle
      name="sdkUIMsg"
      class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

    <%--ResourceBundle for common labels/headers etc--%>
    <uix:bundle
      name="commonResourceBundle"
      class="oracle.sysman.resources.CommonResourceBundle"/>

    <%--ResourceBundle for labels/headers specific to Target Selector--%>
    <uix:bundle
      name="targetSelRB"
      class="oracle.sysman.db.common.targetsel.rb.TargetSelRB"/>

    <uix:document>

      <uix:spacer height="10"/>

      <%--The EM Targets table--%>
      <uix:inlineMessage
        messageTypeBinding="msgType@targetTableMsgInfo@pageSegmentBean@"
        messageBinding="msgTxt@targetTableMsgInfo@pageSegmentBean@">

        <%-- This is a hack to get the tableID. Since id Binding is not
           - supported, I will get the pageSegmentBean from the
           - pageSegmentContext and get the tableID. The importance of
           - tableID is that, it is required for partialPageRenderring.
           - Since a page could use this pageSegment many times, so the
           - table ID should be unique for partial page rendering to work.
           - That means a hard coded value for "id" attribute can't be
           - set.
           --%>
        <%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
        <%@ page import='oracle.sysman.db.common.targetsel.bean.TargetSelPageSegBean' %>
        <%
          PageSegmentContext psContext
            = ( PageSegmentContext) request.getAttribute( "pageSegmentContext");

          TargetSelPageSegBean pageSegBean
            = ( TargetSelPageSegBean) psContext.getPageSegmentBean( );

          String tableID = pageSegBean.getTableID( );
        %>

        <%--
           - The following line creates an anchor. If the including page
           - includes this page segment multiple times (to have multiple
           - targets table, then the anchor will help to focus on the
           - table from which search Target event was fired.
           --%>
        <uix:link nameBinding="tableName@pageSegmentBean@"/>

        <uix:stackLayout>

          <%-- 
             - Show a line of text: "Instances of target: <targetName>" in case 
             - of RAC/CRS target selection.
             --%>
          <uix:styledText 
            rendered="false"
            renderedBinding="compTgtTableTxtRendered@pageSegmentBean@"
            textBinding="compTgtTableTxt@pageSegmentBean@"
            styleClass="OraInstructionText"/>

          <uix:spacer 
            rendered="false" 
            renderedBinding="compTgtTableTxtRendered@pageSegmentBean@"
            height="5"/>

          <%--
             - We need to show single selection or multiple selection for the
             - table based on integrator's choice. However simply putting
             - switcher around "tableSelection" tag does not work. It is a bug
             - in the table tag and workaround is to put the switcher tag
             - around complete table. To shorten the length of the JSP, the
             - table's code is copied in two different files with only change
             - in selection type and either of them is included based on
             - current table selection type.
             --%>
          <uix:switcher childNameBinding="tableSelType@pageSegmentBean@">
            <uix:case name="singleSel">
              <%@ include file="singleSel.jspf" %>
            </uix:case>
            <uix:default>
              <%@ include file="multipleSel.jspf" %>
            </uix:default>
          </uix:switcher>

          <%--
             - Show a tip: "To Select instances of a different target, first 
             - remove already selected instances." in case of CRS/RAC target.
             --%>
          <uix:tip 
            rendered="false"
            textBinding="compTgtTableTipTxt@pageSegmentBean@"
            renderedBinding="compTgtTipTxtRendered@pageSegmentBean@">
          </uix:tip>

        </uix:stackLayout>

      </uix:inlineMessage>

    </uix:document>
  </uix:dataScope>
</oem:pageSegment>
