<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>   

    <%@ include file="/oemTitle.jspf" %>

    <head>
      <script>
          var isNav = ( -1 != navigator.appName.indexOf("Netscape") );
          if ( isNav ) {
             document.captureEvents( Event.KEYPRESS );
          }
          document.onkeypress = getKey;
          function getKey( keyStroke )
          {
             key = (isNav) ? keyStroke.which : event.keyCode;
             if ( "13" == key ) {
               submitForm( 'asmConfigForm', true, {'event':'ok'} );
             }
          }
          function doOnLoad()
          {
              document.asmConfigForm.monitorUserPassword.focus();
              document.asmConfigForm.monitorUserPassword.select();
          }
      </script>
    </head>

    <uix:body onLoad="doOnLoad();">
      <db:form 
        copyParams="target,type,cancelURL"
        name="asmConfigForm" 
        method="post" 
        destination="config"> 

        <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
        <uix:formValue name="target"   valueBinding="target@servletRequest"/> 
        <uix:formValue name="mode"     valueBinding="mode@servletRequest"/>
        <uix:formValue name="emdUrl"   valueBinding="emdUrl@servletRequest"/>

        <uix:pageLayout>

          <%@ include file="/database/global.jspf" %>    

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>    
          
          <%-------------------------
           -  Header
           ---------------------------%>
          <uix:header
            textBinding="header@defaultBean@servletRequest"
            >

            <%-------------------------
             -  Credentials
             ---------------------------%>
            <uix:labeledFieldLayout width="70%" >
              <uix:contents>

               <%--- Monitor Username ---%>
               <uix:styledText 
                 styleClass="OraPromptText" 
                 textBinding="MONITOR_USERNAME@configBundle@servletRequest"
                 />
               <uix:styledText 
                 styleClass="OraDataText" 
                 textBinding="monitorUserName@defaultBean@pageContext" 
                 />

               <%--- Password ---%>
               <uix:messageTextInput 
                 name="monitorUserPassword" 
                 promptBinding="PASSWORD@configBundle@servletRequest"
                 textBinding="monitorUserPassword@defaultBean@pageContext" 
                 messageBinding="(PASSWORD@configBundle@servletRequest)@errors@servletRequest"
                 messageTypeBinding="monitorUserPasswordErrorType@defaultBean@servletRequest" 
                 noAutoComplete="true"
                 columns="40"
                 secret="true"           
                 required="uiOnly"
                 />

               <%--- Confirm Password ---%>
               <uix:messageTextInput 
                 name="confirmMonitorUserPassword" 
                 promptBinding="CONFIRM_PASSWORD@configBundle@servletRequest"
                 textBinding="confirmMonitorUserPassword@defaultBean@pageContext" 
                 messageBinding="(CONFIRM_PASSWORD@configBundle@servletRequest)@errors@servletRequest"
                 messageTypeBinding="confirmMonitorUserPasswordErrorType@defaultBean@servletRequest" 
                 noAutoComplete="true"
                 columns="40"
                 secret="true"           
                 required="uiOnly"
                 />

               <%--- Monitor Role  ---%>
               <uix:styledText 
                 styleClass="OraPromptText" 
                 textBinding="MONITOR_ROLE@configBundle@servletRequest"
                 />
               <uix:styledText 
                 styleClass="OraDataText" 
                 textBinding="monitorUserRole@defaultBean@pageContext" 
                 />

               <%--- Test Connection Button  ---%>
               <uix:styledText/>
               <uix:spacer height="10"/>
               <uix:styledText/>
               <uix:submitButton 
                 textBinding="TEST_CONN@configBundle@servletRequest"
                 name="event" 
                 value="testConn"
                 />

              </uix:contents>
            </uix:labeledFieldLayout>
                                                                                                                                                                                                                                                                                                                                                                                     

            <%---------------------------------------------
             - Tip for Add Mode
             ----------------------------------------------%>
            <uix:spacer height="20"/>

            <uix:rowLayout>
              <uix:cellFormat>  
                <uix:spacer width="5"/>
              </uix:cellFormat>                   
              <uix:tip
                textBinding="CONFIGURE_ASM_TIP@configBundle@servletRequest" 
                />
            </uix:rowLayout>

          </uix:header>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton
                name="event"
                value="cancel"
                textBinding="CANCEL@configBundle@servletRequest"/>
              <uix:submitButton
                name="event"
                value="ok"
                textBinding="OK@configBundle@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>    

      </db:form>  
    </uix:body> 
  </uix:document> 

</uix:renderingContext>	     	     

<%------------------------------  End of File  -------------------------------%>
