<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<uix:renderingContext id="renderingContext">
<uix:bundle name="racMsgBundle"   class="oracle.sysman.db.rsc.rac.RacCommonMsg"/>
<oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    
    <uix:body>  
     <uix:form name="foo" method="POST" destination="config">
      <uix:formValue name="pageName" valueBinding="pageName@servletRequest"/>
      <uix:formValue name="target" valueBinding="target@servletRequest"/> 
      <uix:formValue name="mode" valueBinding="mode@servletRequest"/>
      <uix:formValue name="emdUrl" valueBinding="emdUrl@servletRequest"/>
      <uix:formValue name="returnUrl" valueBinding="returnUrl@servletRequest"/>
     
     <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>
       <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                              
      <uix:contentFooter>
          <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@configBundle@servletRequest" name="event" value="cancel" />
                  <uix:submitButton textBinding="CONTINUE@configBundle@servletRequest" 
                        name="event" value="discover"/>
           </uix:pageButtonBar>
      </uix:contentFooter>

    <uix:stackLayout>
     
      <uix:header 
            textBinding="CLUSTER_FOUND_TITLE@configBundle@servletRequest" > 

      <uix:tableLayout width="100%">
      <uix:rowLayout hAlign="right">
       <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@configBundle@servletRequest" name="event" value="cancel" />
                  <uix:submitButton textBinding="CONTINUE@configBundle@servletRequest" 
                        name="event" value="discover"/>
       </uix:pageButtonBar>
      </uix:rowLayout>
      </uix:tableLayout>
      
      <uix:rowLayout>
         <uix:styledText styleClass="OraFieldText" textBinding="clusterFoundMessage@defaultBean@servletRequest"/>
      </uix:rowLayout>
      
      <uix:include nodeBinding="UINodeForClusterHosts@defaultBean@servletRequest"/>
      
      <uix:rowLayout>
        <uix:styledText styleClass="OraFieldText" textBinding="SEL_OPT@configBundle@servletRequest"/>
      </uix:rowLayout>
      
      <uix:spacer height="5"/>
      <uix:rowLayout>
        <uix:radioButton name="scope" textBinding="HOST_ONLY_OPT@configBundle@servletRequest" 
            value="node"/>
        <uix:spacer width="3"/>    
        <uix:styledText styleClass="OraDataText" textBinding="hostName@defaultBean@servletRequest"/>
      </uix:rowLayout>
      
      <uix:rowLayout>
        <uix:spacer width="20"/>
        <uix:styledText styleClass="OraInlineInfoText" 
             textBinding="HOST_ONLY_OPT_DESC@configBundle@servletRequest"/>
      </uix:rowLayout>      
      
      <uix:spacer height="2"/>
      
      <uix:rowLayout>  
        <uix:radioButton name="scope" textBinding="SCOPE_ALL@configBundle@servletRequest" 
            value="cluster" selected="true"/>
      </uix:rowLayout>  

      <uix:rowLayout>
        <uix:spacer width="20"/>
        <uix:styledText styleClass="OraInlineInfoText" 
             textBinding="SCOPE_ALL_OPT_DESC@configBundle@servletRequest"/>
      </uix:rowLayout>
  
  <uix:spacer height="2"/>
      
  <uix:rowLayout > 
   <uix:hideShowHeader renderedBinding="agentVer11OrHigher@defaultBean@servletRequest" textBinding="ADVANCED_OPTIONS_BUTTON@racMsgBundle" 
    disclosedBinding="advancedOp@servletRequest" id="discoveryHints" formSubmitted="true">
   <uix:spacer height="10"/>
   <uix:rowLayout >
     <uix:contents>                           
       <uix:messagePrompt promptBinding ="DISCOVERY_HINTS@racMsgBundle"/>                  
      </uix:contents>
     <uix:spacer width="5"/>
      <uix:contents>
        <uix:textInput name="discoveryHintParams" columns="100"    textBinding="discoveryHintParams@defaultBean@servletRequest" />
      </uix:contents>
      </uix:rowLayout >
    
     <uix:rowLayout>
        <uix:styledText styleClass="OraInlineInfoText" textBinding="DISCOVERY_HINTS_DESC@racMsgBundle"/>
      </uix:rowLayout>
 
  </uix:hideShowHeader>
  
 </uix:rowLayout>      
        
      </uix:header>

     </uix:stackLayout>      
    </uix:pageLayout>
    </uix:form>
  </uix:body>      
  </uix:document> 
</uix:renderingContext> 
